set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829507';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-1-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      NULL,
      NULL,
      '0442303',
      22.728418,
      3,
      NULL,
      3,
      '032303',
      3.421730,
      ' 0- 9-1996',
      17,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.473511,
      0.682487,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.569023,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.350289,
      1,
      1.480861,
      NULL,
      1,
      1,
      1,
      2.794991,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.942826,
      1.222655,
      0,
      0,
      NULL,
      0.607249,
      1.409780,
      1,
      NULL,
      NULL,
      0,
      2.525465,
      1.590820,
      NULL,
      NULL,
      0.173597,
      1,
      0.603812,
      1,
      3.090650,
      1,
      0,
      5,
      1,
      1,
      5,
      0.501079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.909888,
      1,
      1.155968,
      1.321173,
      0,
      0,
      1.130395,
      1.885876,
      1,
      0.343999,
      NULL,
      0,
      NULL,
      1.217596,
      1,
      0,
      1,
      NULL,
      0.078892,
      NULL,
      1.341537,
      2,
      NULL,
      1,
      7.673582,
      1.164053,
      1.637940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      4.765660,
      2,
      0.520855,
      1,
      6.531325,
      6.881776,
      6.861346,
      1.762012,
      0,
      1,
      2,
      NULL,
      1,
      2,
      1,
      2,
      0,
      1,
      3.607084,
      1.175579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.012707,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      44,
      0.751417,
      0,
      0.441099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      3,
      0.218027,
      NULL,
      NULL,
      NULL,
      3,
      1.045287,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      188.699689,
      1,
      0.716645,
      4.472605,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.932978,
      0.956896,
      1.585686,
      0,
      2.290471,
      1.255372,
      1.509743,
      1.723554,
      NULL,
      0,
      0,
      NULL,
      1,
      0.004314,
      NULL,
      NULL,
      1,
      1.604578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


