set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829507';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      NULL,
      NULL,
      '4133233',
      1.334302,
      0,
      1,
      0,
      NULL,
      3.078897,
      NULL,
      28,
      NULL,
      1,
      NULL,
      2.370259,
      0.656720,
      0.555551,
      0,
      NULL,
      1,
      0,
      NULL,
      0.763942,
      1.381430,
      1.881392,
      1.470214,
      0.025549,
      2.471967,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      1,
      1.313516,
      5.672228,
      1,
      0,
      1,
      2,
      1.656868,
      NULL,
      NULL,
      0.920020,
      NULL,
      NULL,
      4.726033,
      1.745051,
      0,
      0.195220,
      NULL,
      0,
      0.802093,
      NULL,
      3.946696,
      NULL,
      0,
      2.939104,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.474853,
      1.321028,
      NULL,
      NULL,
      0.027267,
      0.428457,
      1,
      NULL,
      4,
      0,
      NULL,
      NULL,
      0.084164,
      NULL,
      NULL,
      1.263658,
      0,
      NULL,
      0,
      NULL,
      0.835325,
      1,
      0.468467,
      1,
      NULL,
      0,
      1.489722,
      NULL,
      1,
      NULL,
      0.946973,
      1.429785,
      1,
      0,
      NULL,
      NULL,
      1.217262,
      3.081545,
      1.268576,
      0,
      0,
      4.788246,
      1,
      6.933383,
      NULL,
      3,
      NULL,
      NULL,
      2.948787,
      6,
      0,
      3,
      3,
      3,
      6.354187,
      NULL,
      3.426824,
      NULL,
      4.875658,
      11,
      1.252410,
      1,
      4.279752,
      2,
      1.841355,
      1.164543,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.647154,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.026155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.288330,
      1.674765,
      0.817367,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5,
      4,
      5.894129,
      1,
      5,
      2.002061,
      186.746073,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.513910,
      1,
      3.263288,
      3,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0,
      1,
      0.638660,
      1,
      1,
      1.148542,
      0.994484,
      NULL,
      1.537562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.581020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.086219,
      '14300',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


