set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829507';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      NULL,
      NULL,
      NULL,
      5,
      2,
      3,
      NULL,
      '023132',
      3,
      ' 5- 8-1980',
      NULL,
      NULL,
      0.464788,
      NULL,
      0,
      NULL,
      0.069406,
      1,
      1.153383,
      0.929517,
      1,
      1.170814,
      0,
      0,
      0.506812,
      0,
      1.325255,
      NULL,
      NULL,
      9.576263,
      0,
      0,
      0,
      1.591182,
      0,
      1,
      3,
      0,
      4,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.186474,
      NULL,
      0,
      3.663178,
      1,
      1.786886,
      3.323752,
      1.124809,
      1,
      1.893440,
      1.902052,
      1,
      0,
      NULL,
      0.594321,
      NULL,
      0,
      NULL,
      0,
      3.991366,
      1.136544,
      0.020173,
      NULL,
      1,
      NULL,
      3,
      1.640956,
      NULL,
      NULL,
      1.825521,
      NULL,
      NULL,
      0.550585,
      0.434952,
      NULL,
      NULL,
      4.308198,
      1.517163,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1.156990,
      0,
      0,
      0.837845,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      5,
      NULL,
      0.294750,
      0,
      NULL,
      2.193763,
      1.247064,
      1.013123,
      9,
      0,
      3.402400,
      2,
      3,
      NULL,
      9.799311,
      7.544045,
      4.354536,
      4,
      7,
      2.071582,
      NULL,
      NULL,
      2.583526,
      1,
      1,
      6.533707,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.686394,
      NULL,
      0,
      NULL,
      0,
      0,
      0.720979,
      1.075585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.764282,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.851277,
      3,
      1.187490,
      NULL,
      NULL,
      NULL,
      6,
      0.946581,
      8,
      0.280127,
      1.177125,
      0,
      NULL,
      1.016556,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3.376297,
      0.882780,
      0,
      NULL,
      1.363333,
      2.327395,
      1.217421,
      1,
      0.845686,
      0.619501,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.802725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.358044,
      NULL,
      '',
      '',
      1.751024,
      '',
      '',
      '',
      3.567146,
      '2040',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


