set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829507';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      NULL,
      '0404330',
      5,
      3,
      NULL,
      3,
      NULL,
      2.279832,
      '11- 2-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      0.422054,
      0,
      1.723843,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.744038,
      1,
      1.431542,
      5,
      NULL,
      1.663558,
      NULL,
      0,
      5.300626,
      1.359589,
      1.202398,
      NULL,
      NULL,
      0,
      2,
      3.867433,
      2,
      1.488439,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.854233,
      3.043518,
      1.679509,
      1.073948,
      2.347491,
      0.883740,
      0,
      0.317687,
      0.749917,
      NULL,
      0.943158,
      1,
      1,
      NULL,
      NULL,
      0.708517,
      1,
      1,
      1,
      0,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0.568491,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      1.380938,
      0.965785,
      0.616015,
      NULL,
      1.639601,
      0.786694,
      1,
      0,
      0,
      NULL,
      NULL,
      4,
      1.739544,
      0.633878,
      0.996573,
      0,
      1,
      0.172519,
      4.193266,
      NULL,
      3,
      3.757779,
      0,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      2,
      0,
      8.413419,
      4.096192,
      6.521560,
      NULL,
      7.638854,
      3,
      1.736075,
      1,
      4.806129,
      0.913279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.383349,
      NULL,
      1,
      2,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.593255,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.764927,
      0.283076,
      2,
      3,
      2,
      NULL,
      7.017264,
      1.649648,
      7.660076,
      5,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.501697,
      1.740899,
      NULL,
      1,
      1,
      2.249875,
      0.189189,
      1,
      0.625069,
      1.112908,
      1.195469,
      1,
      0,
      1.886215,
      0,
      1,
      0,
      1.875403,
      1.222760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.033188,
      '11242',
      NULL,
      '',
      0.877862,
      '',
      '',
      '',
      1.530040,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


