set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829507';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-4-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      '3422310',
      16.455563,
      0,
      NULL,
      0,
      '231401',
      2,
      ' 5- 0-1985',
      4.898479,
      NULL,
      0.528226,
      NULL,
      1.121043,
      0,
      NULL,
      0.164335,
      NULL,
      3.292384,
      1,
      1,
      1.932879,
      0.461369,
      3,
      0,
      0,
      0.961289,
      1,
      1.726908,
      1,
      0,
      5,
      1.246105,
      1.932781,
      1.648551,
      NULL,
      0,
      NULL,
      1.676906,
      NULL,
      0.810536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.685208,
      1.981568,
      NULL,
      NULL,
      2.366282,
      0.681617,
      0,
      0.849250,
      1,
      1.972830,
      1.870034,
      2.054012,
      3,
      NULL,
      1.302712,
      1,
      0,
      3.535600,
      1.356637,
      NULL,
      0,
      0,
      2.370932,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1.781585,
      0.646745,
      NULL,
      NULL,
      0,
      0.477361,
      1.142325,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1.391346,
      NULL,
      1,
      1.134924,
      NULL,
      NULL,
      0,
      0,
      1.792612,
      2.365666,
      0,
      NULL,
      1.605147,
      4.569033,
      4.252353,
      NULL,
      1.050823,
      NULL,
      NULL,
      5.005820,
      1,
      NULL,
      5,
      6,
      3,
      10.330027,
      0,
      6,
      8,
      10,
      0,
      1,
      0,
      1,
      0.639057,
      0.778828,
      0.587244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.435613,
      0.321638,
      1,
      NULL,
      0.029343,
      0.135524,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.341785,
      NULL,
      3,
      0.547645,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.695938,
      0.740626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.337174,
      NULL,
      2,
      1,
      1,
      1.435130,
      NULL,
      NULL,
      0.045265,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.368249,
      3.214493,
      0.907930,
      0,
      2,
      0,
      NULL,
      NULL,
      1,
      2.959337,
      1.045003,
      1,
      0,
      0.995792,
      1.854199,
      0,
      0.232947,
      1.503260,
      NULL,
      1.308492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.989475,
      NULL,
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      1.834655,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


