set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9606885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '033',
      '22',
      15.477643,
      5,
      '4223143',
      11.278498,
      4,
      0.253960,
      0,
      '304324',
      4,
      ' 8-25-1976',
      19,
      27,
      0,
      NULL,
      NULL,
      1,
      3.027070,
      0.533344,
      0.015389,
      1.574626,
      NULL,
      NULL,
      0,
      0,
      3.738779,
      0.359625,
      0,
      1,
      0,
      3.824073,
      0,
      0,
      4.622712,
      4,
      NULL,
      0.174969,
      3.184193,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.978523,
      8.437348,
      3.744022,
      3,
      1.704680,
      0,
      3,
      3,
      0.818890,
      NULL,
      1.812567,
      2,
      NULL,
      2,
      3,
      3,
      2,
      2.915293,
      NULL,
      7.474277,
      NULL,
      9.574036,
      1.305478,
      0,
      0,
      NULL,
      1.950657,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      0,
      1.184741,
      0,
      2,
      1.780825,
      1,
      0.505007,
      0.459143,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0.557256,
      1.874952,
      1,
      0.273709,
      NULL,
      1,
      NULL,
      1.412060,
      0.420158,
      3,
      0,
      3.294210,
      0.642608,
      NULL,
      0,
      1.802367,
      0.080701,
      0.014470,
      0,
      5.307341,
      0.424778,
      3.792051,
      4.698762,
      4,
      6.160551,
      1,
      0,
      5,
      6.296286,
      1.970802,
      4.048569,
      4,
      5.469167,
      1.381809,
      NULL,
      0.188535,
      9.435553,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.526007,
      1,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.522189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2.035371,
      NULL,
      NULL,
      NULL,
      1.294840,
      3.381503,
      1.486604,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.373877,
      1,
      3.811829,
      1.679982,
      0,
      NULL,
      0.269050,
      0,
      0.493013,
      1.298071,
      2,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      0,
      1.222197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.457654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '30000',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      3.887272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


