set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9606885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '104',
      '42',
      37.673595,
      7.507526,
      '1022432',
      2,
      2,
      0.917377,
      2,
      '414410',
      NULL,
      ' 4-18-1976',
      1.601107,
      26.410618,
      0.010537,
      NULL,
      11,
      1,
      3.740940,
      NULL,
      1,
      0.454293,
      1.621124,
      0,
      NULL,
      0.183162,
      NULL,
      1.101114,
      0,
      0.457929,
      1,
      1,
      2,
      1.759447,
      1,
      NULL,
      0,
      0,
      2,
      0,
      NULL,
      0,
      0.713546,
      NULL,
      NULL,
      NULL,
      0.011187,
      NULL,
      NULL,
      NULL,
      7,
      1.816630,
      1.691783,
      1,
      0,
      1.036867,
      0,
      3,
      0,
      0,
      0.648031,
      2.141472,
      2,
      1,
      0,
      2,
      0.939482,
      0,
      NULL,
      0,
      2.689675,
      2,
      0,
      NULL,
      0.709406,
      1,
      NULL,
      NULL,
      1.370423,
      NULL,
      NULL,
      1.782106,
      1.944980,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1.584030,
      1,
      NULL,
      0,
      1,
      NULL,
      1.687782,
      0.662023,
      NULL,
      0.903557,
      5,
      5.021093,
      0.302175,
      5.910598,
      0,
      NULL,
      1,
      5,
      0,
      1.462416,
      1.863205,
      0,
      0.621270,
      3.786698,
      0,
      NULL,
      NULL,
      NULL,
      4.064199,
      1,
      6,
      5,
      NULL,
      NULL,
      4,
      4.387025,
      NULL,
      3,
      0,
      0,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.478838,
      1,
      NULL,
      0,
      0,
      NULL,
      1.578716,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      0,
      0.350597,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      2,
      1.464936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.086978,
      0,
      1,
      0,
      NULL,
      3,
      0.287056,
      3,
      0.067719,
      3.550085,
      2,
      0,
      1,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '34104',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      1.030585,
      '',
      '',
      '',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


