set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9606885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-2-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '330',
      '04',
      34,
      NULL,
      '0411302',
      21.522789,
      6,
      0,
      3,
      '311321',
      2.322120,
      ' 6- 1-1980',
      16.188147,
      NULL,
      0.278843,
      NULL,
      13.351468,
      1.674413,
      2,
      1.289280,
      1.565099,
      3,
      NULL,
      1,
      1,
      1,
      4.579006,
      0.517053,
      1.788138,
      0.632958,
      0,
      0.464358,
      2.393694,
      NULL,
      0.223371,
      5,
      0.531695,
      NULL,
      2,
      1,
      NULL,
      1.825541,
      1.310822,
      0.588240,
      NULL,
      NULL,
      0.320579,
      NULL,
      NULL,
      3,
      0.304525,
      0,
      3.771169,
      1.299070,
      NULL,
      2,
      NULL,
      3.724937,
      2,
      1,
      0.722320,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      3.390609,
      NULL,
      1.582340,
      5.462584,
      7.294539,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.296446,
      NULL,
      0.600752,
      0,
      1.370268,
      0.321988,
      1,
      0.969540,
      0.094708,
      0.155076,
      NULL,
      0,
      1,
      NULL,
      1,
      1.617949,
      0,
      0,
      NULL,
      NULL,
      1.562681,
      4,
      1.837258,
      1.568687,
      2.853812,
      0.520819,
      2.732051,
      NULL,
      5,
      NULL,
      5.265505,
      0.994616,
      0.608596,
      0.010988,
      4.746912,
      0.844839,
      1.596151,
      2,
      0,
      4,
      0.800647,
      5.942537,
      7,
      6.556907,
      7.128691,
      0.474830,
      NULL,
      NULL,
      1.201733,
      0,
      1,
      8,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.877587,
      0,
      0,
      0,
      1,
      1.269510,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.167942,
      NULL,
      NULL,
      3.128552,
      3,
      2,
      NULL,
      0.489008,
      0,
      4,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.616549,
      0.215030,
      0.477463,
      NULL,
      1.120022,
      NULL,
      NULL,
      NULL,
      0.454544,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.081518,
      NULL,
      1.538513,
      1,
      1.660451,
      0.054979,
      1,
      2.995165,
      1,
      0.394381,
      NULL,
      NULL,
      0,
      1,
      0,
      0.433087,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.730676,
      '03030',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


