set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9606885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-5-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      6,
      NULL,
      '2340240',
      30.656682,
      6,
      3,
      2,
      NULL,
      5,
      ' 9- 8-1992',
      6.206970,
      NULL,
      NULL,
      NULL,
      13.721597,
      2,
      1.250382,
      1,
      0,
      0,
      1.241221,
      0,
      0,
      NULL,
      4,
      0,
      0,
      1,
      1.653244,
      NULL,
      2.875676,
      0.113021,
      0,
      7,
      NULL,
      0,
      2,
      1,
      1.113812,
      NULL,
      0,
      0.312357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.836807,
      NULL,
      7.878871,
      3,
      0,
      1,
      0,
      0.100781,
      1.753901,
      NULL,
      NULL,
      0,
      2,
      3,
      NULL,
      0,
      3.782459,
      3,
      NULL,
      2.823849,
      1,
      0.884056,
      4,
      0,
      0,
      3.727342,
      NULL,
      NULL,
      NULL,
      0.836147,
      NULL,
      NULL,
      1,
      NULL,
      0.088997,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.679673,
      NULL,
      0.645333,
      NULL,
      0,
      0,
      0.905578,
      0,
      0,
      NULL,
      NULL,
      1,
      5,
      0,
      0,
      NULL,
      1,
      5.499958,
      1.440546,
      2.743585,
      0,
      NULL,
      1.425522,
      NULL,
      1.680675,
      NULL,
      1.274920,
      0.697311,
      3,
      NULL,
      4.072031,
      5,
      3,
      6.394114,
      NULL,
      1.144642,
      0.967751,
      7,
      NULL,
      0.536781,
      1.214476,
      NULL,
      0,
      0.918729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.237388,
      0.728228,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.088857,
      1.848653,
      1.501430,
      1.075527,
      0.691734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.520316,
      1.399825,
      1.745387,
      1.606525,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.823339,
      3,
      1.303916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.075616,
      0.866417,
      NULL,
      2,
      2.230321,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.462174,
      1.264215,
      NULL,
      0,
      NULL,
      0.415957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      '',
      '',
      2,
      '04114',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


