set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9606885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-11-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '214',
      '34',
      6.562476,
      14.230146,
      '0014121',
      36.119665,
      0,
      NULL,
      NULL,
      NULL,
      3.517555,
      ' 8-17-1992',
      4,
      61.497396,
      1,
      NULL,
      2,
      0.395443,
      3,
      NULL,
      0.847537,
      2.306866,
      1.156326,
      1.803119,
      1,
      1.053374,
      4,
      0.357295,
      NULL,
      0.220919,
      1,
      0.795484,
      2,
      1,
      0.484775,
      1.379118,
      0.266415,
      0.257689,
      5.771962,
      1,
      NULL,
      0,
      0.967301,
      0.032247,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.485939,
      1,
      NULL,
      0,
      1.065919,
      0,
      NULL,
      1.955856,
      1.806951,
      2.989721,
      NULL,
      3,
      0.741199,
      0,
      1,
      1.715032,
      2,
      0,
      1,
      NULL,
      0.465200,
      1.691297,
      4.014293,
      0,
      2,
      1.951059,
      0.204813,
      NULL,
      NULL,
      1.922702,
      NULL,
      NULL,
      1.259641,
      0.108224,
      1,
      1.993642,
      2,
      0,
      1.004220,
      1,
      0,
      0.251251,
      0.849233,
      1.175280,
      1,
      1.232345,
      NULL,
      0,
      1,
      0.591187,
      1,
      NULL,
      NULL,
      2,
      1.848872,
      0,
      5,
      0.647259,
      2,
      1.294527,
      NULL,
      1.158587,
      0,
      4,
      1,
      1,
      4.195090,
      NULL,
      2,
      2,
      6.168362,
      0,
      4,
      NULL,
      4,
      1,
      5.105791,
      1.017080,
      0.786421,
      NULL,
      1,
      NULL,
      0,
      2,
      0.175843,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.296155,
      0,
      0,
      1,
      NULL,
      1.334213,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      NULL,
      0.302503,
      2,
      2,
      0.950163,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.839138,
      0,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.110062,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.798493,
      1.521369,
      3.519836,
      2.124520,
      2.114237,
      1.497919,
      0,
      2.915752,
      0.790181,
      0.408379,
      0,
      NULL,
      NULL,
      0.688956,
      1.481427,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.074942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.211866,
      '10310',
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


