set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9606885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-6-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '114',
      NULL,
      41,
      9.626721,
      '4343431',
      60,
      1,
      0,
      0,
      '143224',
      0.175435,
      '10-25-1990',
      NULL,
      25,
      0.238605,
      NULL,
      5.937152,
      1.476939,
      NULL,
      NULL,
      0,
      1,
      1,
      1.658923,
      2.075178,
      0,
      0,
      1,
      0,
      1,
      1.159635,
      0.927910,
      1.184454,
      1.566618,
      0,
      0.235879,
      0.772190,
      NULL,
      3,
      0,
      3.735622,
      0.001048,
      0.740085,
      1.588852,
      NULL,
      NULL,
      1.368828,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      3.387205,
      1,
      1.838376,
      0,
      1,
      1,
      0.798234,
      1,
      0,
      2,
      NULL,
      2,
      NULL,
      NULL,
      3.881661,
      0,
      NULL,
      NULL,
      4,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.240719,
      1,
      0,
      1.190564,
      5.839354,
      NULL,
      NULL,
      NULL,
      1,
      0.686249,
      NULL,
      1.785315,
      1,
      NULL,
      0.317901,
      1,
      1.070758,
      1.405821,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0,
      5,
      1.724825,
      0.459060,
      0,
      1.509817,
      0,
      1,
      0.857650,
      NULL,
      1,
      NULL,
      1,
      NULL,
      5.638720,
      5.351800,
      1,
      1.659655,
      4,
      7.928482,
      NULL,
      6,
      3,
      NULL,
      1,
      0,
      0,
      1,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.868912,
      1,
      1,
      1,
      1,
      0,
      0.836329,
      0.476367,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.982435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.941536,
      NULL,
      NULL,
      NULL,
      5.102242,
      0.659113,
      0,
      1.416631,
      NULL,
      0,
      1.107252,
      NULL,
      NULL,
      NULL,
      1.522771,
      0.299662,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.797442,
      0,
      NULL,
      2.348436,
      1,
      2.513677,
      NULL,
      1,
      1.489265,
      3.751870,
      0.742591,
      1.882136,
      NULL,
      1.134944,
      NULL,
      1.740353,
      1,
      NULL,
      0.390227,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '22343',
      '',
      '',
      1,
      '',
      '',
      '',
      0.737797,
      '',
      '',
      '',
      0,
      0,
      2,
      2,
      3,
      2,
      1.835250,
      1,
      1);
commit;
end;
/


