set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9606885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-12-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '032',
      '03132302',
      14.804143,
      25.410313,
      '1243114',
      2.009210,
      3,
      NULL,
      NULL,
      '401001',
      NULL,
      ' 6-12-1976',
      19.101153,
      NULL,
      1.803531,
      NULL,
      11,
      1,
      3.771084,
      1.750097,
      0,
      1,
      1.995550,
      NULL,
      2,
      1,
      5,
      1,
      0.525350,
      1.544853,
      0,
      0.681611,
      0.029191,
      1.901792,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      1.095622,
      1.149667,
      1.030580,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      3.969438,
      7.601831,
      0,
      1.103971,
      1.370179,
      0,
      1,
      1.209738,
      2,
      NULL,
      2,
      0.880015,
      1,
      0.840237,
      0.979311,
      NULL,
      2,
      3.191037,
      0,
      0.173453,
      NULL,
      4,
      0,
      0,
      NULL,
      0.448375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      5.725205,
      NULL,
      1.092089,
      1,
      0.266746,
      1,
      0,
      NULL,
      NULL,
      1.830395,
      1.217520,
      NULL,
      1.594970,
      1.398138,
      1,
      NULL,
      0.065700,
      4,
      1,
      1.422864,
      NULL,
      1.276412,
      3,
      0.209462,
      3,
      0.820685,
      0.885836,
      0.662276,
      1.293506,
      NULL,
      5.836398,
      0,
      7.340397,
      2.839123,
      2,
      5.571715,
      6,
      NULL,
      5,
      4.852023,
      0.710783,
      4.795970,
      NULL,
      4,
      3,
      0.095498,
      0.789583,
      6.535498,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.064350,
      0,
      0,
      1,
      1.538653,
      1.776951,
      0,
      1.305730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      2,
      0.887950,
      NULL,
      NULL,
      NULL,
      0.508577,
      0.742084,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.806826,
      1.885510,
      1,
      3.972406,
      3.034147,
      0.771988,
      1,
      1.225908,
      0.683230,
      0,
      0.667687,
      1.962866,
      0,
      NULL,
      1,
      NULL,
      0.402623,
      1.510539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '14333',
      '',
      '',
      0,
      '',
      '',
      '',
      0.239470,
      NULL,
      '',
      '',
      1,
      2.045336,
      3,
      NULL,
      NULL,
      2.641536,
      2.508986,
      NULL,
      3.584779);
commit;
end;
/


