set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9606885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '312',
      '23442401',
      25.582517,
      6.614629,
      '4341430',
      9,
      NULL,
      1.882525,
      0,
      '103142',
      4.794868,
      ' 9- 6-1979',
      20,
      40,
      1.012621,
      NULL,
      NULL,
      NULL,
      NULL,
      1.761211,
      0,
      3,
      0,
      0.106529,
      2.016495,
      0,
      0,
      0,
      1,
      1.587995,
      1.111537,
      0,
      NULL,
      1,
      1,
      0.549616,
      1.851978,
      0.660208,
      0,
      1,
      1.330075,
      2.788435,
      0,
      1.155762,
      NULL,
      NULL,
      1.929099,
      NULL,
      NULL,
      NULL,
      0.965583,
      6.625800,
      2.195463,
      NULL,
      NULL,
      1.377930,
      0,
      1.157099,
      NULL,
      NULL,
      1.975910,
      NULL,
      0.713803,
      NULL,
      1,
      3.342731,
      1.651374,
      1,
      0.041849,
      0.414886,
      0.821307,
      2.067717,
      1,
      2,
      2.853006,
      NULL,
      NULL,
      NULL,
      0.918867,
      NULL,
      NULL,
      1,
      3,
      1,
      1,
      5,
      1,
      0.622816,
      1,
      0,
      1.714640,
      0,
      0,
      0.618993,
      0,
      0,
      NULL,
      1.997023,
      1,
      0.770895,
      NULL,
      0,
      NULL,
      1,
      1.630611,
      0,
      1.903805,
      3.481048,
      1.931727,
      5,
      0.151382,
      0.407444,
      0,
      2,
      0.350181,
      3.809697,
      0.093933,
      1.395058,
      7,
      5,
      5,
      1.684140,
      1.051634,
      0.051527,
      1.716500,
      NULL,
      NULL,
      2.174914,
      7,
      0.151781,
      1.331870,
      1.856194,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.972882,
      1.128910,
      0,
      0,
      0,
      1.575980,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.745098,
      1,
      0.409297,
      3.490183,
      3,
      4,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.323436,
      0.737547,
      1.144027,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.683480,
      4.455520,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.072453,
      NULL,
      NULL,
      NULL,
      0.387900,
      2,
      1.517506,
      3.074265,
      NULL,
      NULL,
      0,
      0.743936,
      NULL,
      0,
      0,
      0.502243,
      NULL,
      1,
      1.147359,
      0.136366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      '',
      0.689600,
      '',
      '',
      '',
      0.289803,
      NULL,
      '',
      '',
      0,
      0.019459,
      NULL,
      3,
      1,
      3,
      3.545615,
      2.798439,
      2.538072);
commit;
end;
/


