set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9606885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '203',
      '04023010',
      35,
      4,
      '3221130',
      40.863004,
      NULL,
      2,
      0,
      '124414',
      0.115386,
      ' 6-12-2001',
      23,
      NULL,
      1.505396,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      1,
      1.964084,
      NULL,
      1,
      1.041582,
      NULL,
      NULL,
      1,
      1,
      4,
      0,
      0,
      1.616896,
      NULL,
      1.768282,
      1.505186,
      NULL,
      1,
      0,
      0,
      0,
      1.120710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      9,
      NULL,
      0.814051,
      0.532562,
      1.567826,
      NULL,
      3.770619,
      1.489192,
      2.348070,
      1.190257,
      NULL,
      0.499325,
      1.321621,
      3.797980,
      1.203706,
      2.573600,
      0.757763,
      1,
      NULL,
      0,
      NULL,
      0.447213,
      1,
      0,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.394580,
      4,
      0.008049,
      1.441333,
      0,
      0.349560,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1,
      1.619336,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.106483,
      1,
      1,
      4.369817,
      1.198546,
      1.285050,
      4.407809,
      1.669993,
      3.131688,
      1.647451,
      5.284525,
      1,
      3.314853,
      5,
      3,
      1,
      0,
      5.433866,
      7.047873,
      NULL,
      NULL,
      0.899425,
      5.991947,
      NULL,
      NULL,
      0,
      0.238839,
      4,
      2,
      0,
      0,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.820280,
      1,
      0,
      NULL,
      NULL,
      0.723123,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.102544,
      NULL,
      NULL,
      NULL,
      NULL,
      1.763396,
      2,
      0.721007,
      NULL,
      1.303392,
      0,
      2.959357,
      2.417458,
      1,
      NULL,
      NULL,
      NULL,
      3.309203,
      0.591217,
      1.968110,
      2.025537,
      0,
      0,
      1.245168,
      NULL,
      NULL,
      NULL,
      1,
      1.980196,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.870356,
      1,
      0.189705,
      1.671580,
      1,
      1,
      1,
      NULL,
      0.076230,
      3.153594,
      0.429376,
      1,
      0,
      0.375954,
      1,
      NULL,
      1.635838,
      1,
      NULL,
      0.312761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.288184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '42031',
      NULL,
      NULL,
      1,
      NULL,
      '',
      '',
      1.383738,
      '2144',
      '',
      '',
      1.175860,
      NULL,
      3.526125,
      1,
      0,
      NULL,
      1.400687,
      NULL,
      2.836187);
commit;
end;
/


