set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9606885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-6-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '120',
      NULL,
      66.714444,
      49,
      '4330034',
      29,
      NULL,
      0.276373,
      1,
      '232244',
      5.982902,
      ' 4- 0-1994',
      0,
      22.909117,
      0,
      NULL,
      12.143752,
      3.271481,
      0,
      1.488068,
      1.165584,
      NULL,
      1,
      1,
      1,
      1,
      2,
      1.880646,
      0,
      1,
      0.697542,
      3.372292,
      4.631658,
      1.883992,
      NULL,
      1,
      0.450684,
      1,
      6.970573,
      1,
      3,
      1,
      3.577995,
      NULL,
      NULL,
      NULL,
      1.752064,
      NULL,
      NULL,
      10.742686,
      0.050994,
      6,
      0,
      NULL,
      NULL,
      3,
      2,
      0,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1.031760,
      3,
      2.388316,
      7.558246,
      4,
      1,
      7.753518,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.619411,
      NULL,
      2,
      0,
      2,
      1,
      0.976625,
      1.212101,
      1,
      1,
      NULL,
      0.138371,
      1,
      0,
      1,
      0,
      1.534847,
      1.443869,
      1.578379,
      NULL,
      0.258203,
      3,
      1,
      1,
      3,
      1.459730,
      3.583380,
      1,
      5.127870,
      0.242791,
      1,
      1,
      0,
      0,
      1,
      0.383956,
      NULL,
      NULL,
      8.413981,
      2.316277,
      6,
      4,
      NULL,
      1.455619,
      4.556697,
      3.580250,
      NULL,
      0,
      1.625007,
      1.205331,
      0,
      NULL,
      1.114420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.057999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.988341,
      2,
      0,
      1.206566,
      1,
      0,
      1.451782,
      0.092971,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.544262,
      1.353259,
      6,
      4.938894,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.024193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.401443,
      2,
      NULL,
      NULL,
      0,
      0.665869,
      NULL,
      1,
      NULL,
      NULL,
      0.430349,
      1.368928,
      NULL,
      0,
      1.115448,
      NULL,
      0.731043,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.815409,
      '42424',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1.725494,
      '',
      '',
      '',
      2,
      NULL,
      1.114708,
      NULL,
      2.508742,
      NULL,
      3.025202,
      1.840121,
      0.490682);
commit;
end;
/


