set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9606885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-12-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '104',
      '21422433',
      63,
      NULL,
      '4423004',
      92,
      0,
      NULL,
      1,
      NULL,
      5.488322,
      NULL,
      25.961645,
      45,
      1.077525,
      NULL,
      16.173200,
      NULL,
      0,
      0.696331,
      0,
      1,
      1.660162,
      1.538658,
      2.723245,
      NULL,
      5.003933,
      1.528592,
      0,
      NULL,
      1.827175,
      1,
      1,
      1.012412,
      NULL,
      3,
      0.438650,
      NULL,
      3.752185,
      1,
      0.764593,
      1.004280,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8.894701,
      3.916566,
      7.170869,
      NULL,
      1.335951,
      0,
      NULL,
      3.900014,
      3.504920,
      2.824978,
      NULL,
      2,
      0,
      0,
      0,
      1,
      2,
      2,
      1.092823,
      0,
      0,
      0.485661,
      3.809534,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.107674,
      3.773367,
      1.653506,
      NULL,
      NULL,
      0.043728,
      0.371764,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.938271,
      1.458880,
      NULL,
      1,
      5,
      1,
      1,
      5,
      0.676455,
      4.663623,
      0,
      2.634379,
      0,
      0,
      0,
      NULL,
      1,
      2,
      NULL,
      4,
      7,
      NULL,
      2,
      1,
      1.918058,
      5,
      6,
      6,
      4.334704,
      4,
      4,
      2,
      0,
      NULL,
      2,
      0.836094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.226447,
      1.344033,
      NULL,
      0,
      0,
      1.174016,
      1.340665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.207396,
      1,
      2.688837,
      3,
      NULL,
      0.052914,
      0,
      3,
      4.100648,
      3,
      1.219876,
      NULL,
      NULL,
      NULL,
      3.523194,
      NULL,
      2.445532,
      0.751535,
      5.948930,
      1,
      7.513634,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.771741,
      1,
      NULL,
      2,
      2.278122,
      0,
      3.382269,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.772858,
      1.495842,
      0,
      1.010950,
      1,
      0.387879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.869431,
      '01213',
      '',
      '',
      0,
      '22000',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      5.946665,
      NULL,
      NULL,
      5.401125,
      0,
      2,
      3,
      3);
commit;
end;
/


