set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9606885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '132',
      NULL,
      17.243617,
      54,
      '2214400',
      4,
      2,
      0.368683,
      NULL,
      '121011',
      1.913352,
      '11- 8-1982',
      26,
      47,
      1.662176,
      NULL,
      14,
      0,
      2.038089,
      0.840516,
      0.493913,
      NULL,
      0.881813,
      1,
      3,
      0.867641,
      2.799268,
      1.134993,
      1,
      NULL,
      1.860207,
      0,
      3.449698,
      NULL,
      0,
      0.880577,
      1.915178,
      0,
      3.446119,
      0,
      NULL,
      NULL,
      NULL,
      1.613674,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.304970,
      NULL,
      1.465046,
      2.154474,
      NULL,
      3.789551,
      3.640167,
      NULL,
      3.385004,
      1,
      3.245826,
      2,
      0,
      NULL,
      1,
      0,
      0,
      0,
      5.609098,
      1,
      NULL,
      0,
      1.469085,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.711356,
      5,
      0,
      0.978485,
      NULL,
      0,
      1.235297,
      0.861635,
      1.244606,
      1,
      0,
      1,
      0,
      0.084246,
      NULL,
      NULL,
      0.705941,
      0.934447,
      1,
      NULL,
      1.000137,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      5.039822,
      1,
      1.651641,
      1,
      0.101975,
      0.566698,
      1,
      0,
      NULL,
      1,
      5.364517,
      0,
      6.755688,
      4.031650,
      3,
      NULL,
      NULL,
      4.818763,
      6,
      7,
      4,
      7,
      3,
      0.065802,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566956,
      NULL,
      NULL,
      NULL,
      NULL,
      5.276504,
      1.477656,
      1.184669,
      NULL,
      0,
      1.385640,
      NULL,
      1.276452,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      3.792997,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.939634,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.177454,
      0.340830,
      0,
      3,
      NULL,
      NULL,
      1,
      3.903589,
      0,
      1.176300,
      3.837416,
      0.609562,
      0,
      0,
      1,
      1.761217,
      1,
      1.988832,
      1,
      0.244990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      '',
      NULL,
      0,
      '04414',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      3,
      NULL,
      1.812288,
      1.335229,
      NULL,
      NULL,
      3,
      0.428581,
      0);
commit;
end;
/


