set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9606885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '230',
      '40431131',
      40.148316,
      NULL,
      '0040042',
      NULL,
      3,
      2,
      3,
      NULL,
      5,
      ' 5-13-1975',
      2,
      5.908877,
      1,
      NULL,
      NULL,
      0.507088,
      NULL,
      0.046658,
      0,
      NULL,
      1.187758,
      1.829150,
      3.748593,
      0.860671,
      2.917132,
      0,
      0,
      1,
      0.346600,
      NULL,
      NULL,
      1,
      1.455944,
      1,
      0.196135,
      0.630851,
      NULL,
      1,
      NULL,
      1.175299,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.695361,
      1.205506,
      4.491780,
      0.179875,
      1.864392,
      NULL,
      NULL,
      2,
      0.154113,
      3.471097,
      1.970298,
      2,
      NULL,
      1.714104,
      1.757158,
      NULL,
      0.595405,
      NULL,
      3.603515,
      7.754575,
      1,
      7.316384,
      7.390254,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.074467,
      NULL,
      NULL,
      1,
      1.347991,
      1.260335,
      1,
      NULL,
      0.651793,
      1.365461,
      0,
      NULL,
      1,
      1.867495,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      1.350508,
      NULL,
      1.297988,
      0.372622,
      3.395337,
      1,
      0,
      NULL,
      0,
      1.363258,
      3,
      1.612655,
      5,
      NULL,
      NULL,
      NULL,
      5,
      7,
      NULL,
      5.693613,
      4,
      2.292872,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0,
      0,
      1.591505,
      1.758650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.347151,
      1,
      0,
      0,
      1,
      1.987963,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      1.403973,
      1.930664,
      4,
      2.449250,
      2.998392,
      0,
      NULL,
      NULL,
      NULL,
      5.885271,
      0.111004,
      1.337675,
      2.255043,
      1.665559,
      2,
      4.578328,
      0.630344,
      NULL,
      NULL,
      0.794996,
      4.991450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.541658,
      1.452546,
      NULL,
      2,
      1,
      0,
      0,
      0.433779,
      1,
      NULL,
      1,
      1.204850,
      1,
      1.246287,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.578753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.605658,
      NULL,
      '',
      '',
      1.039511,
      '10031',
      '',
      '',
      1,
      '',
      '',
      NULL,
      3,
      0.903441,
      2.587875,
      3,
      1,
      NULL,
      0.229757,
      2.377261,
      NULL);
commit;
end;
/


