set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9606885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3023',
      '40024130',
      NULL,
      53.602235,
      '1212314',
      150.833347,
      1,
      NULL,
      2,
      '022214',
      1,
      '11-23-1990',
      39,
      47,
      1.727559,
      NULL,
      NULL,
      NULL,
      0.178640,
      0,
      1.363705,
      NULL,
      0.614063,
      1.393935,
      3,
      NULL,
      1.461757,
      0,
      NULL,
      0,
      1,
      1.076714,
      NULL,
      NULL,
      1,
      0.763180,
      1.113414,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.507064,
      NULL,
      NULL,
      NULL,
      2,
      9,
      1.924461,
      NULL,
      0.784571,
      NULL,
      2,
      0.156312,
      0,
      NULL,
      1.882803,
      0,
      3.379970,
      1,
      2,
      1.788107,
      0.953392,
      1,
      7,
      NULL,
      6,
      7.300087,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.790890,
      NULL,
      NULL,
      NULL,
      0,
      1.356928,
      0.256003,
      1.408101,
      NULL,
      0.344386,
      1.953088,
      NULL,
      1.575610,
      0,
      NULL,
      NULL,
      NULL,
      1.280679,
      0,
      0.501691,
      1.008905,
      5,
      0,
      4,
      1,
      0,
      0.375791,
      1,
      NULL,
      NULL,
      0,
      2.821725,
      1.383482,
      NULL,
      4,
      6.773853,
      1,
      4.306362,
      6,
      7.375487,
      3,
      5,
      2.445413,
      2.024298,
      3.030795,
      1,
      1.440689,
      1.030435,
      3,
      0.131524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.573412,
      1,
      0,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.526655,
      NULL,
      NULL,
      NULL,
      2.376556,
      0.162672,
      0.379886,
      0,
      NULL,
      1,
      0.475420,
      1.100691,
      NULL,
      NULL,
      0.231369,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.719070,
      3.727319,
      NULL,
      3.151946,
      3.297468,
      1,
      0.021658,
      1.462147,
      0.015874,
      1,
      1,
      0,
      0.969093,
      0.494375,
      1.279404,
      0,
      0.526684,
      0,
      0.114247,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.245415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '02110',
      '41233',
      '',
      1.856709,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      2,
      0.593948,
      3,
      2.175519,
      1.541743,
      1.717959,
      NULL,
      NULL,
      1);
commit;
end;
/


