set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9606885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1104',
      NULL,
      21,
      42.631452,
      '4011403',
      38,
      1,
      0,
      NULL,
      '333114',
      5.955181,
      ' 5-24-1981',
      33,
      4,
      NULL,
      NULL,
      3.920944,
      0,
      2,
      0,
      NULL,
      1,
      NULL,
      0.129398,
      1.640852,
      0.354617,
      0,
      0.153403,
      0.350073,
      NULL,
      0.033442,
      1.697353,
      NULL,
      0.953831,
      1.516963,
      1,
      1.585396,
      0,
      3,
      1,
      1.119653,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9.124381,
      4,
      5.931079,
      2.460274,
      1,
      1.082929,
      2.357750,
      3,
      3,
      3,
      1.974270,
      3,
      0,
      3.816129,
      0.166738,
      0.673921,
      0,
      1,
      1.272557,
      2,
      NULL,
      4,
      0.822688,
      0,
      2,
      1,
      0.745117,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.836186,
      0.327920,
      NULL,
      1,
      2.063473,
      1.703753,
      0.604544,
      0.368963,
      0,
      NULL,
      0.587158,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0.542127,
      0,
      NULL,
      0,
      5,
      0.662207,
      1.855514,
      4,
      1.766327,
      1.028653,
      1.562359,
      1.425018,
      1,
      0.128243,
      0.958423,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      4.102928,
      5,
      1.061047,
      1.725861,
      3,
      7.231937,
      2.149550,
      2.959876,
      6,
      0,
      1.567879,
      0.772274,
      0.375005,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.840861,
      1,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.971272,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.819085,
      1.052160,
      1,
      2.115238,
      2,
      2,
      NULL,
      1.591078,
      NULL,
      NULL,
      NULL,
      1.599203,
      0,
      NULL,
      NULL,
      1,
      2,
      1.431446,
      NULL,
      NULL,
      NULL,
      0,
      5.064593,
      1.993438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.159247,
      NULL,
      1,
      2.114427,
      2,
      3.851171,
      2.400858,
      0.172661,
      1,
      0.630762,
      0.594047,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      1.659803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      '',
      1,
      '33112',
      NULL,
      '',
      0.861308,
      '3414',
      '3120',
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2.377984,
      2,
      3,
      2.907770);
commit;
end;
/


