set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9606885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34343221',
      19,
      NULL,
      '1110443',
      11,
      2,
      NULL,
      1,
      '004342',
      4,
      ' 6-14-1990',
      13,
      63,
      1,
      NULL,
      1,
      0,
      0,
      0.420745,
      1,
      0.194349,
      0,
      0.626487,
      NULL,
      1,
      0,
      0,
      0.841742,
      0,
      1.701637,
      1.797135,
      1.446616,
      NULL,
      0,
      0,
      0,
      0.210794,
      NULL,
      0,
      0.910468,
      0.664300,
      3.415857,
      1.226464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      11,
      3,
      0,
      2,
      1.710579,
      0.154761,
      1,
      0,
      0,
      NULL,
      1.797003,
      0,
      1,
      NULL,
      1,
      NULL,
      0.750538,
      0.775157,
      1,
      1,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0.364606,
      0.991106,
      0,
      0.742609,
      1.564016,
      NULL,
      1.664851,
      NULL,
      1,
      NULL,
      0.297485,
      0,
      0,
      0,
      NULL,
      0.840691,
      3.702340,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.479050,
      NULL,
      2.050625,
      1.352153,
      1,
      6,
      5.388867,
      3.321938,
      0.789908,
      5,
      3.713498,
      NULL,
      NULL,
      0,
      5.395401,
      4,
      NULL,
      1,
      1,
      9.994877,
      0.712856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.947131,
      0.391640,
      NULL,
      NULL,
      1.713391,
      1.065090,
      0.876501,
      1.045823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.517861,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.480589,
      1.927027,
      0.108424,
      NULL,
      NULL,
      NULL,
      3.746503,
      0.092719,
      0.061964,
      NULL,
      NULL,
      2,
      1.740762,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.496405,
      NULL,
      NULL,
      2.881041,
      NULL,
      NULL,
      1.604247,
      2.856616,
      0,
      NULL,
      0.726511,
      1.841206,
      0,
      1.719202,
      1,
      1,
      0.230436,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.320501,
      NULL,
      '',
      '',
      2.462574,
      NULL,
      NULL,
      '',
      NULL,
      '2003',
      '1113',
      '',
      3,
      0.174813,
      1,
      1,
      3,
      0,
      NULL,
      0.893814,
      2.453163);
commit;
end;
/


