set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9606885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-12-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0213',
      '10021213',
      25.801636,
      35,
      '2310141',
      95,
      4,
      0.314828,
      0,
      '301113',
      NULL,
      NULL,
      37.496207,
      51.288783,
      0.807059,
      NULL,
      13,
      NULL,
      3,
      1.147990,
      1,
      2.352933,
      1.209179,
      1.094328,
      2,
      1,
      3,
      1,
      1.922543,
      0.424049,
      0,
      0.837403,
      4.368190,
      0,
      0.646117,
      0.607934,
      1,
      NULL,
      2,
      0,
      0,
      2,
      1.876086,
      0.691564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6,
      0.042190,
      1.832057,
      0,
      1,
      2.260186,
      NULL,
      NULL,
      NULL,
      1.565944,
      0.815973,
      0,
      3,
      1.453295,
      0,
      0.196317,
      0.633645,
      0.926735,
      1.751344,
      0.897624,
      6.394061,
      0.132992,
      NULL,
      0,
      1.332198,
      1.216594,
      NULL,
      NULL,
      1.186615,
      NULL,
      NULL,
      NULL,
      2,
      4,
      1,
      0.414332,
      NULL,
      1,
      0,
      0,
      0.923210,
      NULL,
      NULL,
      0.843102,
      NULL,
      0.963079,
      1,
      1,
      0.689165,
      0.254834,
      NULL,
      0,
      2.759774,
      1.916692,
      1,
      4,
      0,
      3,
      0,
      5,
      3,
      0.176728,
      0.845894,
      1.838302,
      1.462597,
      5.186111,
      NULL,
      5,
      7,
      0,
      1,
      4.844484,
      3,
      4.839001,
      1.335047,
      NULL,
      NULL,
      0.057209,
      0,
      3,
      0,
      0.801749,
      4.853563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.144834,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      3,
      1.283340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.209725,
      1.583493,
      1.474910,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      3.127936,
      0.633548,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.417462,
      NULL,
      1.345051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.953288,
      1.391476,
      0.747321,
      3.276718,
      3.524470,
      1,
      1.851320,
      1.778889,
      2.512895,
      1.505531,
      0,
      1,
      0.698747,
      0.823950,
      1.268814,
      0.719306,
      0.997088,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.869759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.651759,
      '32034',
      '',
      '',
      3.543264,
      '22121',
      '',
      '',
      0.842204,
      '3114',
      '2211',
      NULL,
      5.652224,
      2,
      3.506147,
      NULL,
      1.712418,
      0,
      2.419450,
      2,
      3);
commit;
end;
/


