set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '220',
      '44431241',
      74,
      NULL,
      NULL,
      2,
      2,
      2,
      NULL,
      '302043',
      4.747285,
      NULL,
      56,
      101,
      0,
      NULL,
      NULL,
      1.556393,
      2,
      1,
      1,
      3.960629,
      0,
      0.404427,
      3,
      1.305963,
      1.576013,
      0,
      0.444009,
      NULL,
      1.854494,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.502188,
      0.934649,
      2.956161,
      0,
      1.967752,
      NULL,
      0.436288,
      NULL,
      NULL,
      NULL,
      1.247859,
      NULL,
      NULL,
      5.854071,
      3.414169,
      5.061017,
      1.211877,
      0,
      1,
      1,
      NULL,
      0.506469,
      NULL,
      0,
      NULL,
      0.689638,
      2.388932,
      0,
      3,
      0.077932,
      0,
      0.992577,
      1.020326,
      1.456678,
      1.080389,
      5.097998,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.154175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      0.946819,
      0,
      NULL,
      0.939494,
      NULL,
      0,
      0,
      1.673154,
      0,
      1.983365,
      NULL,
      NULL,
      1.604906,
      1,
      1,
      0,
      NULL,
      0.271402,
      4.709453,
      NULL,
      NULL,
      1,
      2.645899,
      0,
      NULL,
      5,
      4,
      1.049631,
      0,
      NULL,
      NULL,
      1,
      2.087928,
      NULL,
      8.182900,
      NULL,
      7.012026,
      5.625543,
      NULL,
      6.917122,
      1.368206,
      0,
      1,
      2.825456,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.752602,
      1.748518,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.341247,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.794961,
      NULL,
      3.567010,
      NULL,
      0.463086,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.641653,
      0,
      1.011607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.391935,
      1,
      0,
      0,
      0,
      1.621929,
      1.865045,
      1.816855,
      0,
      1.961494,
      NULL,
      1.124000,
      0,
      NULL,
      1,
      0,
      1.768764,
      1.418912,
      0.959622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.641056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.974377,
      '40101',
      '30100',
      '',
      0,
      '',
      '',
      '',
      2.372778,
      NULL,
      NULL,
      '',
      0,
      1,
      NULL,
      3,
      0,
      1,
      3.463654,
      2.869833,
      3);
commit;
end;
/


