set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '41314334',
      25.978448,
      NULL,
      '4422440',
      25.885362,
      1,
      2.566712,
      0,
      '031204',
      5.761086,
      NULL,
      21,
      7.100266,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      1,
      1.614275,
      0.192331,
      1,
      1,
      4,
      0,
      0,
      1.497551,
      1.236790,
      0.548097,
      6.855397,
      NULL,
      1,
      1,
      1.559729,
      NULL,
      NULL,
      1,
      0.308025,
      3.269638,
      NULL,
      0.257852,
      NULL,
      NULL,
      1.874286,
      NULL,
      NULL,
      2.636351,
      2,
      0,
      NULL,
      0.803369,
      0.726533,
      0,
      0.744639,
      0.455752,
      NULL,
      3,
      2.474311,
      1.762064,
      NULL,
      3,
      0,
      NULL,
      0.269506,
      0.494030,
      1.094812,
      1.046937,
      1.418244,
      6.943284,
      1,
      1,
      0.432467,
      NULL,
      NULL,
      NULL,
      0.722148,
      NULL,
      NULL,
      1,
      1,
      1.809807,
      1.838373,
      0,
      0.949402,
      NULL,
      0.686724,
      1.238466,
      5,
      NULL,
      2,
      1,
      1.135267,
      1.633114,
      0.933129,
      0,
      NULL,
      0.229925,
      NULL,
      1,
      2.791903,
      NULL,
      NULL,
      0,
      0.236021,
      NULL,
      0,
      2.157134,
      NULL,
      0,
      NULL,
      0.066179,
      4.329695,
      3,
      0,
      1.858783,
      3,
      5,
      NULL,
      3,
      1,
      NULL,
      3,
      2,
      0.766529,
      5.219663,
      3.142856,
      2,
      1.528675,
      1,
      1,
      1.635534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.764231,
      NULL,
      1.304938,
      0.904705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.960153,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.541434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.828727,
      2.498646,
      1.476059,
      1.446011,
      3,
      2,
      1.632637,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.661542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.974742,
      2.682773,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      1,
      0.175473,
      1,
      0,
      0.560833,
      1,
      0,
      0.828722,
      0.217305,
      1,
      1.775704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.816451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.822606,
      '00414',
      '30044',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      2.414032,
      2.959248,
      2.815514,
      NULL,
      3,
      0.679109,
      2,
      3.065501,
      0.734175);
commit;
end;
/


