set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1234',
      '10100221',
      11.113151,
      NULL,
      '4023321',
      8.148250,
      3,
      0.300858,
      NULL,
      '401133',
      1.241573,
      ' 2-29-1990',
      37.387959,
      14,
      0.270532,
      NULL,
      NULL,
      1,
      1.343937,
      0,
      1.620519,
      1,
      0.408651,
      0,
      NULL,
      1,
      NULL,
      0.763768,
      0,
      0.080096,
      0,
      0.576694,
      NULL,
      1,
      1.027082,
      1.914015,
      0.799106,
      1.242569,
      7.062120,
      0,
      3,
      2,
      1.885328,
      0.578783,
      NULL,
      NULL,
      1.572546,
      NULL,
      NULL,
      4,
      NULL,
      1,
      3.920225,
      1,
      0,
      0,
      3,
      1,
      3.631306,
      3,
      1,
      0,
      0.199661,
      2,
      0,
      NULL,
      1.923633,
      1,
      1.979704,
      0.005574,
      NULL,
      6.385658,
      1,
      1,
      1.585145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0.992494,
      0,
      NULL,
      0.874514,
      1,
      4.619677,
      1.784401,
      0.798701,
      0,
      NULL,
      0.144933,
      1,
      1,
      NULL,
      0.879162,
      NULL,
      1.610183,
      4.326280,
      0.327534,
      0.062382,
      1.439509,
      0.761717,
      5.187213,
      0,
      4,
      NULL,
      1,
      0.996911,
      1.506806,
      4.955152,
      2,
      0.437769,
      NULL,
      1.894937,
      4,
      3.250912,
      5,
      5.064158,
      NULL,
      1.452942,
      NULL,
      NULL,
      0.669233,
      2.337717,
      1,
      0.977922,
      1.646045,
      9,
      0.725992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.240815,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.735778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.933313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.061556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.941137,
      0.570832,
      2.418899,
      0,
      0.746558,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3.944612,
      1,
      NULL,
      1.150742,
      NULL,
      0.537729,
      0,
      1,
      0.869748,
      0.558248,
      0,
      1.703083,
      NULL,
      0.885095,
      1.427389,
      0.939491,
      0.076122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      3,
      NULL,
      2.633496,
      3,
      3,
      NULL,
      3.491113,
      1);
commit;
end;
/


