set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3144',
      '24323301',
      38.556009,
      13.894970,
      '0430221',
      31.551366,
      4,
      1.710003,
      0,
      '404434',
      3.457798,
      '10-12-1995',
      NULL,
      183.571446,
      0,
      NULL,
      1.803501,
      0,
      1.401059,
      0,
      NULL,
      0,
      1.312737,
      1.026581,
      0.083945,
      0.775570,
      3.681884,
      1.527190,
      NULL,
      0.275856,
      NULL,
      1,
      6,
      NULL,
      1.516690,
      1.639647,
      1,
      0.637674,
      1.208341,
      NULL,
      0,
      3,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1.118747,
      NULL,
      1.460709,
      1,
      1.289087,
      NULL,
      2.436744,
      1,
      2.587532,
      1.597519,
      1,
      1.067860,
      NULL,
      2.460097,
      1.019565,
      2.733175,
      1.918910,
      1.672509,
      NULL,
      1,
      0,
      6.621888,
      0,
      2,
      1.377873,
      NULL,
      NULL,
      NULL,
      0.780931,
      NULL,
      NULL,
      0,
      1.283762,
      1.667481,
      NULL,
      1,
      1,
      0,
      0.132910,
      1.204418,
      2.349497,
      NULL,
      1.726916,
      0.519417,
      4.986060,
      NULL,
      1.039096,
      NULL,
      1,
      1,
      NULL,
      0,
      3.246545,
      0.148605,
      0.079182,
      1,
      1.723552,
      0,
      NULL,
      3,
      1,
      1,
      1,
      3.392354,
      2,
      3.941292,
      0.282831,
      0.244262,
      NULL,
      4,
      NULL,
      3.729615,
      8.447419,
      4.852887,
      6.735111,
      NULL,
      1.084298,
      7.471485,
      NULL,
      1.135642,
      NULL,
      NULL,
      NULL,
      1.944032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.575043,
      0.780683,
      0,
      1,
      1.005372,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      2.821472,
      2,
      0.373332,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.774771,
      2.220430,
      1.680036,
      1,
      1,
      0.052880,
      0.923357,
      0.049822,
      0.965365,
      0.093069,
      NULL,
      0.338186,
      0,
      0,
      0.705578,
      0,
      1,
      0.367621,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '03110',
      '1314',
      '',
      1,
      '',
      '',
      '',
      3,
      '2101',
      '',
      '',
      NULL,
      0.844818,
      1.373627,
      0.592249,
      1,
      3.877953,
      1.325204,
      3,
      1.245191);
commit;
end;
/


