set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3134',
      '31333222',
      12,
      50.463667,
      '0131341',
      11.821098,
      2,
      0.986104,
      NULL,
      '232423',
      NULL,
      ' 3- 2-2002',
      NULL,
      4,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0.088845,
      1.629367,
      0.136441,
      1,
      NULL,
      0,
      1.452993,
      NULL,
      1,
      1.693670,
      NULL,
      1.023791,
      0.041203,
      0.628551,
      0,
      1,
      1.726822,
      1.783102,
      0.329862,
      4,
      1,
      3,
      2,
      1.438896,
      NULL,
      NULL,
      NULL,
      0.407198,
      NULL,
      NULL,
      1,
      4,
      1,
      2,
      0.796823,
      0.964734,
      NULL,
      1,
      1.164905,
      0.931226,
      0,
      NULL,
      2,
      0.552944,
      0,
      1,
      1.922055,
      NULL,
      1,
      1,
      NULL,
      0,
      5,
      1,
      NULL,
      0,
      1.429169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.563664,
      0,
      0.580005,
      1.923029,
      1.023415,
      0,
      NULL,
      0.524731,
      1,
      NULL,
      NULL,
      1.422261,
      1,
      5,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.509239,
      3,
      0.080654,
      1,
      1,
      1.622666,
      1.109813,
      NULL,
      0,
      0,
      NULL,
      1,
      2.114386,
      1,
      NULL,
      0.356030,
      1,
      5,
      NULL,
      4.704164,
      6.765551,
      NULL,
      6,
      7.977964,
      4,
      NULL,
      0,
      1.698497,
      1,
      1,
      1,
      2.761737,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.071583,
      NULL,
      1,
      0,
      1,
      0.444552,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.723702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      0,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.883329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.608726,
      3.145691,
      2,
      NULL,
      2.977213,
      3,
      1.276122,
      1,
      1.745589,
      0.488833,
      NULL,
      1,
      1.924960,
      0,
      1.624438,
      1.441505,
      0.754638,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '23200',
      '2132',
      NULL,
      0,
      NULL,
      '',
      '',
      3,
      NULL,
      '',
      '',
      4,
      0.166360,
      NULL,
      0,
      3,
      2.088489,
      3,
      0,
      3.675666);
commit;
end;
/


