set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3411',
      '41011322',
      90,
      29,
      NULL,
      35,
      3,
      0,
      2,
      '400101',
      1.776388,
      ' 1-20-1999',
      131,
      34,
      1,
      NULL,
      NULL,
      0.333620,
      3,
      1.714730,
      1.036641,
      1.553859,
      1.980910,
      2.489548,
      0,
      0,
      4,
      1,
      0.427444,
      0,
      0,
      1.646718,
      1,
      0,
      2.845121,
      1,
      NULL,
      1.233172,
      2.213060,
      0,
      1.363632,
      0,
      1.594360,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      5.662809,
      1.401209,
      0,
      NULL,
      0,
      3,
      NULL,
      0,
      3,
      NULL,
      0.333614,
      1.907769,
      2,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      1.023051,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.252356,
      NULL,
      NULL,
      0,
      0,
      1.741042,
      NULL,
      5,
      1.231436,
      0.253997,
      0.630582,
      0,
      1.469187,
      1.940438,
      0,
      0.928534,
      NULL,
      1.115849,
      NULL,
      0.638626,
      1,
      0.735028,
      NULL,
      0,
      5.190577,
      NULL,
      2,
      3.570823,
      1,
      2,
      0,
      NULL,
      0,
      2,
      2.164441,
      NULL,
      NULL,
      1.027014,
      1.786987,
      3.575941,
      0.778960,
      NULL,
      1,
      4,
      2.562383,
      NULL,
      NULL,
      0.086193,
      NULL,
      7,
      4,
      0.913217,
      1.029598,
      1,
      3.314387,
      1.448069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.590885,
      1,
      1,
      NULL,
      1.789480,
      1,
      1.218532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.488695,
      NULL,
      NULL,
      NULL,
      NULL,
      2.416538,
      3.166949,
      1.498988,
      1.459388,
      1.758684,
      1.150099,
      NULL,
      3,
      1.912273,
      NULL,
      NULL,
      NULL,
      0.236558,
      1,
      0,
      1.739996,
      2.378572,
      NULL,
      1.686422,
      NULL,
      NULL,
      NULL,
      0.473443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.723477,
      1,
      1.797366,
      2.440504,
      NULL,
      0.945139,
      0,
      0.598186,
      3.221473,
      1,
      1.571039,
      0,
      1.106062,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '21214',
      '0222',
      '',
      NULL,
      '',
      NULL,
      NULL,
      3.068924,
      NULL,
      '',
      '',
      5.173620,
      2,
      1,
      NULL,
      NULL,
      3.396655,
      3.714173,
      2.928201,
      2);
commit;
end;
/


