set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9895821';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1110',
      '41043031',
      61.019737,
      57,
      '1241112',
      4.229219,
      3,
      3.704510,
      1,
      '413012',
      5,
      ' 2-12-1977',
      30.232494,
      64,
      0,
      NULL,
      NULL,
      0.232149,
      0,
      0,
      3.824707,
      1,
      0.315933,
      1.709130,
      1,
      1,
      1.000262,
      NULL,
      1,
      1.217203,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      1,
      1.317771,
      0,
      0,
      1.013904,
      3,
      0,
      0.579480,
      NULL,
      NULL,
      0.188166,
      NULL,
      NULL,
      1.420422,
      1,
      0.569341,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.551360,
      0.831935,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.413113,
      0,
      5.073534,
      2.330129,
      1,
      0,
      0.315240,
      1.324799,
      NULL,
      1,
      1.338109,
      1.729499,
      0.105377,
      0.120266,
      0.239214,
      1,
      0,
      1,
      NULL,
      NULL,
      0.821295,
      NULL,
      0.687211,
      1,
      1.659489,
      NULL,
      2,
      NULL,
      4.608602,
      1.321828,
      4,
      NULL,
      2.723439,
      NULL,
      4.057226,
      1.592742,
      1,
      0,
      NULL,
      1.722649,
      0.960244,
      6,
      NULL,
      10.110910,
      NULL,
      NULL,
      4,
      4.751699,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1.613139,
      0.736235,
      0,
      0.809904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      0.934095,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      2.976024,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.946980,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.840004,
      1.320675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.864016,
      3.067015,
      2,
      1,
      0.169390,
      2.999867,
      1.913284,
      3.461283,
      0.315079,
      3,
      0,
      0.132648,
      1,
      1.293243,
      0.286760,
      1.624331,
      0.021218,
      1.678367,
      0.120295,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.928710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.921635,
      NULL,
      '',
      '',
      1.452951,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      4.062807,
      1,
      NULL,
      0.788204,
      4.484963,
      0,
      0.131789,
      NULL,
      2.764917);
commit;
end;
/


