set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7925101';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '012',
      NULL,
      15,
      NULL,
      '0103130',
      NULL,
      6,
      0,
      2,
      '431322',
      3.101696,
      NULL,
      53.414981,
      23.777653,
      0,
      NULL,
      1.187067,
      1.950683,
      NULL,
      0.394234,
      0,
      1.690023,
      0.689394,
      0.125893,
      1.586982,
      0,
      0,
      1.575833,
      1.109578,
      1,
      NULL,
      NULL,
      0.445288,
      1.382970,
      NULL,
      0,
      1.133458,
      1.744894,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.672819,
      NULL,
      1.053565,
      1.653813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.634101,
      1.354970,
      1,
      0.423743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.821348,
      0.762684,
      1,
      1,
      0.561403,
      1.403033,
      0.697805,
      1.009193,
      1,
      1,
      0.435311,
      0.342191,
      0.266868,
      1,
      1.579718,
      0.608939,
      0,
      NULL,
      0,
      1,
      1,
      0,
      1,
      1,
      0.331512,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.101455,
      NULL,
      1.231140,
      NULL,
      NULL,
      2,
      9.579170,
      0,
      5,
      7.466050,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      6.985957,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.886847,
      1.584555,
      0,
      NULL,
      0.189434,
      1.037251,
      1,
      1.691878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.180670,
      NULL,
      NULL,
      NULL,
      NULL,
      0.942102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.504970,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      5,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.124234,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.489641,
      1.792167,
      0.449203,
      1,
      0.564102,
      0,
      1.934123,
      3,
      0,
      1,
      1.028239,
      0,
      0.680662,
      1.711122,
      1.193615,
      1,
      1.191986,
      1.675977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.867822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.630281,
      '22411',
      '',
      '',
      1.676670,
      '',
      '',
      '',
      0,
      '2043',
      NULL,
      '',
      4.318269,
      3.260865,
      0,
      0.622535,
      3,
      2.820679,
      NULL,
      0,
      2.148490);
commit;
end;
/


