set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7925101';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '403',
      '41402244',
      37,
      0.396851,
      '4213442',
      19.888832,
      0,
      NULL,
      NULL,
      NULL,
      4,
      ' 8-10-1978',
      NULL,
      20.423050,
      0.655491,
      NULL,
      0.922846,
      0,
      0.187318,
      0.011525,
      NULL,
      0,
      0.086675,
      1.209716,
      1.362586,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.058054,
      NULL,
      0.040582,
      NULL,
      1.160361,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.552008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.426959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.237039,
      NULL,
      0.403182,
      0.657954,
      0,
      NULL,
      NULL,
      1.244089,
      1.626293,
      NULL,
      1,
      0,
      1,
      0.479668,
      1.810076,
      NULL,
      0.899924,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.317937,
      1.330405,
      NULL,
      1.895823,
      0.730884,
      0,
      1.914761,
      1,
      0,
      1,
      1.216239,
      0,
      0,
      NULL,
      1,
      0,
      0.851123,
      0.327610,
      3.447872,
      3.387067,
      0,
      3,
      1.519055,
      NULL,
      1.250627,
      1.204304,
      NULL,
      NULL,
      NULL,
      1.752035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.240645,
      0,
      1,
      0,
      NULL,
      0.600217,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.335872,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      1,
      1.104679,
      NULL,
      NULL,
      NULL,
      0.858413,
      NULL,
      0,
      4,
      1.568370,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.755390,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.730885,
      0,
      0.780179,
      NULL,
      1.113165,
      1,
      0.858384,
      0,
      2,
      1,
      1,
      0.900741,
      1.837581,
      0.620633,
      1.151184,
      0,
      1.000751,
      0.215455,
      1.120607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '11112',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      1.298126,
      '2300',
      NULL,
      '',
      NULL,
      3.245437,
      NULL,
      0,
      0,
      2,
      3.883565,
      NULL,
      2.564730);
commit;
end;
/


