set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8325901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      NULL,
      NULL,
      '1001002',
      NULL,
      1,
      NULL,
      0,
      '130222',
      3.205281,
      NULL,
      2.758873,
      NULL,
      1.517899,
      NULL,
      3.172625,
      NULL,
      1.324127,
      NULL,
      0.407094,
      1,
      1,
      NULL,
      2,
      1,
      6.931702,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.865939,
      1.923589,
      1.792712,
      1.837834,
      NULL,
      0,
      NULL,
      1,
      0,
      0.168196,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.919898,
      0.625088,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.840062,
      0,
      2.653502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.545937,
      NULL,
      1,
      1.725682,
      NULL,
      0,
      1,
      1.141835,
      1,
      0.357229,
      1,
      0,
      5.912055,
      0,
      1,
      0.334001,
      0,
      0,
      NULL,
      NULL,
      2,
      1.107035,
      1.847637,
      NULL,
      2.237918,
      2.247971,
      0,
      4.730964,
      4.287437,
      NULL,
      6,
      0,
      1,
      0,
      0.916180,
      0.063121,
      9.370408,
      9.859861,
      2.528849,
      3,
      4.332900,
      7.052516,
      0.256447,
      2,
      NULL,
      7,
      9.247575,
      3,
      0.312878,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.113136,
      2.213985,
      0,
      NULL,
      0,
      0,
      1,
      1.507899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.208668,
      NULL,
      27,
      NULL,
      1.911721,
      0.137510,
      NULL,
      1.615202,
      NULL,
      0,
      NULL,
      1.368812,
      2.870410,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.070743,
      6.013986,
      NULL,
      NULL,
      1,
      0.956938,
      NULL,
      NULL,
      NULL,
      0.191114,
      4.559305,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.179043,
      NULL,
      3.280940,
      2.151573,
      3,
      3,
      3,
      1,
      2,
      0.113724,
      0,
      0,
      0.371340,
      0,
      0,
      1,
      1,
      NULL,
      0.931214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '43212',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


