set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8325901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      NULL,
      NULL,
      '0434323',
      32.151018,
      1,
      3.597845,
      1,
      NULL,
      NULL,
      NULL,
      41,
      NULL,
      0,
      NULL,
      NULL,
      0.287680,
      1,
      0.399490,
      NULL,
      NULL,
      1.950356,
      0.206380,
      1,
      0.882641,
      0.335601,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      0.713645,
      1,
      1.326222,
      0.465442,
      NULL,
      8,
      1,
      5.721168,
      2.192147,
      0.365735,
      1.357547,
      NULL,
      NULL,
      0.406169,
      NULL,
      NULL,
      5,
      1,
      NULL,
      0.480247,
      1.059416,
      0,
      NULL,
      1.350132,
      1,
      1.488673,
      1,
      1.221071,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      1,
      0.451026,
      1.167183,
      NULL,
      3,
      0,
      2,
      NULL,
      0.099471,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.585272,
      0.777531,
      1.636592,
      NULL,
      5,
      3,
      1.653968,
      NULL,
      4.534080,
      2,
      2.413747,
      1.194052,
      4,
      0.229726,
      1.937049,
      0,
      0,
      0.003675,
      NULL,
      1.760077,
      1,
      4,
      1,
      NULL,
      1,
      4.817146,
      0,
      NULL,
      3,
      2,
      0.515936,
      NULL,
      1.507907,
      4,
      1.042474,
      1,
      4.790198,
      8.667078,
      7,
      4,
      2.536051,
      6.098624,
      9.599052,
      NULL,
      3,
      17,
      4,
      0.838091,
      1.475509,
      1.680027,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.554070,
      0,
      1,
      0,
      NULL,
      1.597667,
      0.536000,
      1.826980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.282331,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1.865495,
      2,
      0.585131,
      NULL,
      8,
      0,
      1,
      1.615670,
      1.829982,
      2,
      4,
      0,
      1,
      7.189782,
      0.821403,
      NULL,
      0.688580,
      NULL,
      NULL,
      NULL,
      NULL,
      1.167727,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      1.054605,
      2.430548,
      0,
      NULL,
      1,
      1,
      3.755685,
      1.421690,
      1,
      0,
      NULL,
      0.958570,
      NULL,
      0.869980,
      0,
      0.872915,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '32220',
      '',
      '',
      0.631579,
      NULL,
      '',
      NULL,
      0.881951,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


