set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8325901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      NULL,
      NULL,
      '3441044',
      22.270612,
      5,
      NULL,
      3,
      NULL,
      2,
      ' 5-19-1992',
      NULL,
      NULL,
      1.533571,
      NULL,
      1.916692,
      0,
      0,
      1,
      0.832187,
      0.865162,
      1,
      1,
      0.079313,
      NULL,
      0.813010,
      0.351237,
      NULL,
      NULL,
      NULL,
      1,
      8.748987,
      1,
      1.815770,
      NULL,
      1,
      0,
      1.216924,
      1,
      NULL,
      1,
      1.877083,
      NULL,
      NULL,
      NULL,
      0.881765,
      NULL,
      NULL,
      7,
      NULL,
      1,
      2.388656,
      0,
      0,
      0,
      0,
      0,
      0.787490,
      0,
      1,
      0,
      1,
      0.011005,
      NULL,
      1.482322,
      1,
      NULL,
      0.292069,
      1.140707,
      0,
      3.965334,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.115788,
      1,
      NULL,
      1,
      4,
      1,
      NULL,
      0,
      1.224960,
      2.604023,
      0.326995,
      2,
      0.048246,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.301354,
      3,
      1.845295,
      9,
      5.679288,
      NULL,
      5.453167,
      1.102073,
      6,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0.142009,
      0,
      11,
      NULL,
      3.556388,
      6,
      7.583095,
      1.625616,
      8.870202,
      8.592515,
      0,
      2,
      NULL,
      2.347383,
      1,
      1.390988,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.572702,
      0.138233,
      0,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.233806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.420682,
      NULL,
      0.089595,
      2,
      3.608988,
      NULL,
      2.536685,
      7,
      2.710830,
      6,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7.344987,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.395758,
      2,
      1,
      1.258324,
      1.196537,
      3,
      3,
      NULL,
      NULL,
      1.036399,
      0,
      0,
      NULL,
      NULL,
      0,
      1.280220,
      0.920493,
      1,
      0.141150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.712965,
      '32304',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


