set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8325901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-9-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      NULL,
      NULL,
      NULL,
      87.491423,
      3,
      1,
      3,
      '411241',
      1.423347,
      ' 4- 7-2001',
      19.780300,
      NULL,
      1.795294,
      NULL,
      0.814594,
      2,
      0.946891,
      0,
      1.447977,
      1.246923,
      NULL,
      1.533769,
      1.616916,
      0.066133,
      NULL,
      NULL,
      0.443016,
      2.387517,
      1.928104,
      NULL,
      NULL,
      1.797887,
      1,
      0,
      NULL,
      0,
      7.516065,
      1,
      4.796655,
      4.804130,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.179892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.708350,
      NULL,
      6.731687,
      0,
      0,
      1,
      0.369476,
      NULL,
      NULL,
      0.781745,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.217357,
      0.392462,
      1,
      2.131087,
      1.995291,
      NULL,
      2,
      1,
      1,
      0,
      4,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0.052296,
      1.368440,
      1.480981,
      1,
      NULL,
      1.547745,
      6,
      1.033571,
      NULL,
      7.303402,
      3,
      0,
      5,
      0.442600,
      1.196739,
      7.838698,
      7.865450,
      2,
      3,
      2,
      NULL,
      6.096013,
      3,
      3.485368,
      0.079291,
      NULL,
      0.451392,
      1.539058,
      1.370429,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.884290,
      NULL,
      0,
      1,
      1.271746,
      1,
      1,
      0.520006,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.869684,
      1,
      3,
      1,
      NULL,
      0.636095,
      3,
      3,
      3,
      7,
      3.710352,
      1,
      NULL,
      NULL,
      NULL,
      4.865983,
      1,
      0.414393,
      6.676834,
      4.686059,
      1,
      0.824452,
      NULL,
      NULL,
      NULL,
      2,
      8.313428,
      1.998792,
      0,
      5,
      3.346830,
      9,
      0.710366,
      0,
      1,
      0,
      0,
      0,
      1,
      3,
      0,
      1,
      NULL,
      2,
      1.579117,
      0.726896,
      1,
      0.686342,
      1.517180,
      0,
      1.920761,
      0.807191,
      NULL,
      1.534555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '14101',
      '',
      '',
      0.969651,
      '',
      NULL,
      '',
      1.888821,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


