set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8325901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '142',
      NULL,
      14.150484,
      1,
      '0003211',
      156.151580,
      2,
      3,
      2,
      '424204',
      2.013028,
      ' 2-23-1980',
      NULL,
      55,
      1.200641,
      NULL,
      NULL,
      1,
      3.630495,
      1,
      0.359068,
      0,
      NULL,
      NULL,
      2.293484,
      0,
      3,
      1,
      NULL,
      NULL,
      0,
      1.817070,
      0,
      1,
      0.009964,
      1,
      1.964570,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      1.716785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.625287,
      1.616947,
      0,
      1.342529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.910963,
      1.659015,
      1.600958,
      0.636959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.004705,
      1.979789,
      NULL,
      3.127661,
      3.760364,
      NULL,
      NULL,
      NULL,
      NULL,
      1.321919,
      1.281234,
      NULL,
      0,
      0,
      0,
      1,
      1,
      NULL,
      0,
      1.510807,
      0,
      1,
      1.516443,
      0,
      1.770871,
      0.054410,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3.723667,
      0.703492,
      NULL,
      1.920745,
      4.741892,
      NULL,
      1.467607,
      8,
      0.146368,
      0,
      1.970219,
      2,
      0,
      2,
      0.836323,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      0,
      NULL,
      0,
      1.249869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.029547,
      NULL,
      NULL,
      3.110664,
      3.042855,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.092646,
      3.645266,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      7,
      5,
      0.124493,
      0,
      1.198478,
      NULL,
      NULL,
      NULL,
      1.483483,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.529647,
      0.640435,
      1,
      3,
      1,
      3,
      0.379653,
      1,
      2.576022,
      1.396975,
      1,
      NULL,
      0,
      1,
      1,
      1,
      0.925942,
      1,
      0.020443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.128052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '02223',
      '',
      '',
      0.206463,
      '',
      '',
      '',
      1.685121,
      '',
      NULL,
      NULL,
      3.749560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


