set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8325901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '122',
      '04',
      24.255170,
      23.918691,
      '4423122',
      8,
      2,
      2,
      3,
      '002242',
      5.527477,
      ' 4-14-1981',
      30,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.300365,
      1,
      1,
      0.647989,
      NULL,
      0,
      2.072407,
      0,
      4.555465,
      NULL,
      0.821310,
      NULL,
      0.143487,
      6.832694,
      0.075875,
      1.619358,
      1.188984,
      0.529370,
      1.155409,
      0.741012,
      9,
      1,
      3,
      1,
      0.366617,
      0.096514,
      NULL,
      NULL,
      0.737429,
      NULL,
      NULL,
      3.415588,
      0.327972,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.856740,
      1,
      1.075638,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.844214,
      0,
      3.685877,
      1.356700,
      2,
      NULL,
      1,
      NULL,
      1,
      6.492256,
      1,
      0.355548,
      1.558974,
      7,
      1,
      0.639101,
      1,
      1.276352,
      1,
      NULL,
      1,
      0,
      0,
      0,
      0.957639,
      1,
      0.150076,
      0.873123,
      0.994368,
      1,
      NULL,
      1,
      1.619413,
      1.298477,
      0.127955,
      1,
      0,
      0,
      3,
      2.788972,
      NULL,
      NULL,
      2.723013,
      1.226397,
      9.813610,
      5,
      0,
      4.882733,
      3.235206,
      1,
      NULL,
      5.104053,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7.159119,
      1,
      0,
      1.201515,
      1,
      0,
      0.483320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.034984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.457731,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.478660,
      8.587993,
      NULL,
      NULL,
      2,
      1.074823,
      NULL,
      NULL,
      NULL,
      0.584681,
      7.387384,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0.380121,
      1.760186,
      3,
      0.164094,
      0.836316,
      0.887637,
      NULL,
      0.955291,
      0,
      1,
      0,
      1.003548,
      1,
      0.291039,
      0.397445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '12334',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      4,
      0.869323,
      2.127979,
      NULL,
      1,
      3,
      1.710848,
      0,
      3.066934);
commit;
end;
/


