set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8325901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '434',
      '21',
      1,
      29,
      '3201022',
      118.928397,
      6,
      1.889609,
      0,
      NULL,
      1.592799,
      ' 8-25-1985',
      1,
      NULL,
      0.333592,
      NULL,
      1.854777,
      1.098893,
      2.022748,
      NULL,
      1,
      1,
      NULL,
      1,
      3,
      0.013610,
      NULL,
      1,
      NULL,
      1.327816,
      NULL,
      NULL,
      2,
      0.927083,
      1.346237,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      3.280497,
      1.552743,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.821232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.437876,
      0.957199,
      1.777221,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.090093,
      3,
      0,
      4,
      0,
      2,
      0.655059,
      0.180158,
      1.393716,
      2,
      1,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1.188306,
      NULL,
      NULL,
      0.930493,
      NULL,
      NULL,
      1,
      3,
      1,
      1,
      3,
      5.021787,
      5.415871,
      0,
      0,
      0,
      NULL,
      0.882368,
      1.521358,
      7.333418,
      8,
      7,
      NULL,
      7,
      NULL,
      4,
      9.385393,
      5,
      0.795101,
      4,
      1.441551,
      1.335130,
      NULL,
      0.424709,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.124139,
      2,
      1,
      1,
      0.893746,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.645500,
      NULL,
      9,
      3,
      0.078385,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.951019,
      NULL,
      NULL,
      NULL,
      NULL,
      0.563522,
      2,
      3,
      0.463597,
      4.146892,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.801261,
      0.805893,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.330158,
      1,
      0,
      0.533727,
      NULL,
      2,
      1,
      NULL,
      0.852662,
      0.781760,
      0.361924,
      NULL,
      1,
      0,
      1,
      0,
      1.639347,
      0.826534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.442393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '42114',
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.671100,
      5.553996,
      NULL,
      NULL,
      0.981146,
      1.203768,
      3,
      3,
      NULL);
commit;
end;
/


