set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8325901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '100',
      '14333023',
      NULL,
      39,
      '3320404',
      113,
      5,
      3,
      NULL,
      NULL,
      2.869887,
      '10- 1-1994',
      30,
      32.672359,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.040827,
      0.829675,
      NULL,
      0.902824,
      NULL,
      0.228618,
      NULL,
      8,
      1.942267,
      1.114434,
      NULL,
      0.327946,
      0.220613,
      9.536172,
      NULL,
      NULL,
      NULL,
      1.859138,
      0,
      3.661379,
      0,
      1,
      1,
      0.230895,
      1.676566,
      NULL,
      NULL,
      0,
      1,
      2,
      1.892679,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.822883,
      3.788670,
      NULL,
      0.792665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      NULL,
      NULL,
      1,
      5.742334,
      1,
      NULL,
      1.543665,
      0.864543,
      1,
      1,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.052089,
      1,
      0,
      NULL,
      3,
      1.617486,
      7,
      1.503346,
      7,
      NULL,
      1,
      0.884337,
      4,
      0,
      4.809649,
      9,
      7,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      4,
      11.237325,
      4.275206,
      0.095663,
      1.008324,
      1,
      3.195778,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.137819,
      0,
      1,
      0,
      0.623986,
      NULL,
      0.338875,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.542640,
      NULL,
      7.832060,
      NULL,
      NULL,
      4.991037,
      0,
      1.183104,
      0,
      3.072063,
      3,
      2,
      1.606419,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.300077,
      7.592841,
      4.344425,
      NULL,
      0,
      4.792041,
      1.739070,
      NULL,
      NULL,
      NULL,
      NULL,
      0.170737,
      1.945203,
      3,
      5,
      NULL,
      1.335169,
      1.242886,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      0,
      0.089504,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      1.027671,
      0.482774,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '44341',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1.288761,
      NULL,
      '',
      '',
      NULL,
      4.823580,
      2,
      2.027637,
      NULL,
      1,
      2,
      3,
      NULL);
commit;
end;
/


