set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8325901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-9-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '013',
      '31323224',
      NULL,
      13,
      '0003000',
      199.830301,
      3,
      2.311761,
      3,
      '121330',
      2.693529,
      ' 0-28-1981',
      47.490536,
      46,
      1.382344,
      NULL,
      1.843922,
      1,
      2,
      1,
      1,
      0.218849,
      NULL,
      0.387351,
      1,
      1.683025,
      NULL,
      1,
      1.660313,
      0,
      1,
      5,
      NULL,
      NULL,
      4,
      3.872955,
      3,
      1.396517,
      5.875432,
      0,
      0.538647,
      3,
      0.527969,
      1.548016,
      NULL,
      NULL,
      1.970939,
      4.891234,
      NULL,
      2.829861,
      1,
      1.725291,
      0.449718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.193125,
      2,
      1.682726,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.578374,
      0.724079,
      0.795966,
      NULL,
      NULL,
      NULL,
      1,
      1.302711,
      6,
      0.607115,
      0.560493,
      1,
      3.622587,
      0.849686,
      1.364996,
      NULL,
      0,
      0.945417,
      NULL,
      1,
      0,
      1,
      0.785847,
      2.135452,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.554888,
      3,
      1,
      2.168615,
      8.755118,
      2,
      NULL,
      7,
      NULL,
      2,
      9.084334,
      7,
      2.188900,
      1.330328,
      7.702314,
      3,
      0.545765,
      0.403959,
      0.460975,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.456118,
      0,
      0,
      1.001594,
      0.914690,
      1,
      0.240519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4.012991,
      1.003892,
      2.189254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.811325,
      NULL,
      NULL,
      NULL,
      3.313733,
      NULL,
      10,
      4,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      3.372501,
      6,
      2.394636,
      5.202607,
      3,
      3.107676,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      NULL,
      2,
      NULL,
      NULL,
      0.175215,
      NULL,
      NULL,
      3,
      NULL,
      1.988428,
      0.990393,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      5,
      1.931270,
      0,
      3.712867,
      1.675876,
      0.942464,
      2,
      3);
commit;
end;
/


