set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8325901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '01010002',
      39,
      NULL,
      '2343331',
      243,
      NULL,
      3,
      1,
      '422213',
      3.779009,
      ' 3-19-1977',
      56,
      NULL,
      1.794929,
      NULL,
      0.718535,
      1.483280,
      1,
      0.919984,
      0,
      0,
      0,
      0,
      1,
      1.155083,
      1.959984,
      0,
      1,
      1.449445,
      0,
      NULL,
      5.480212,
      5.654469,
      5,
      0,
      0.663071,
      NULL,
      7.242385,
      0,
      4.450041,
      2,
      1,
      0,
      NULL,
      NULL,
      3,
      4,
      5.204783,
      1.879761,
      NULL,
      1.495714,
      1.898173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.873887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.463432,
      NULL,
      NULL,
      1,
      1.213481,
      2.078408,
      1.408424,
      1,
      5.024965,
      0.253423,
      1,
      1.547202,
      NULL,
      1,
      1,
      NULL,
      1,
      1.063444,
      NULL,
      0.121340,
      0.875898,
      1.297893,
      1,
      0.563998,
      3.721335,
      2,
      3.157666,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1,
      NULL,
      0,
      5.990176,
      7.156245,
      NULL,
      7.340650,
      3.537348,
      3.481425,
      7,
      3.460985,
      NULL,
      1,
      10,
      6.699280,
      1,
      0,
      NULL,
      5.404787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      1,
      0,
      1.370625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      1.430073,
      2,
      3.538734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.229869,
      1.596970,
      NULL,
      NULL,
      NULL,
      5.716837,
      0,
      11,
      3.064164,
      1.397921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.634339,
      NULL,
      0.658076,
      2,
      NULL,
      NULL,
      5.640415,
      NULL,
      NULL,
      0,
      1,
      1.038440,
      1.926280,
      3,
      2,
      2.929813,
      1,
      1.523165,
      2,
      1,
      0,
      1.732900,
      1,
      0.541228,
      1,
      0.556263,
      0,
      NULL,
      0.140216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.818961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.494924,
      '41214',
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      1.441970,
      '',
      '',
      NULL,
      NULL,
      6,
      1,
      2,
      1,
      1,
      NULL,
      0.222880,
      2.951251);
commit;
end;
/


