set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8325901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '130',
      '21231224',
      NULL,
      NULL,
      '0314341',
      NULL,
      4,
      3.052192,
      NULL,
      '414231',
      5,
      ' 6-28-1977',
      48,
      29.452844,
      0,
      NULL,
      1,
      0,
      3,
      0.328415,
      0.482827,
      1,
      0,
      1.368295,
      2,
      NULL,
      4,
      1.771052,
      NULL,
      0.854185,
      1,
      3.000801,
      3.777237,
      1.512269,
      5,
      0,
      NULL,
      0,
      0.957074,
      1,
      0,
      0,
      3.416588,
      NULL,
      NULL,
      NULL,
      0.257865,
      NULL,
      NULL,
      1,
      1,
      1.060692,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.435724,
      1,
      3.547171,
      0.420424,
      NULL,
      1.778892,
      0,
      1,
      1.727463,
      0,
      NULL,
      0,
      1,
      6.698320,
      1,
      1,
      1.670507,
      0,
      0.337669,
      NULL,
      NULL,
      0.467262,
      0,
      1.842306,
      1,
      1.116245,
      NULL,
      3.267509,
      NULL,
      NULL,
      NULL,
      NULL,
      7.715406,
      1,
      3,
      1,
      4.035221,
      NULL,
      0.248251,
      7.729364,
      7.388319,
      NULL,
      8.724746,
      4.879356,
      5.959771,
      3.252955,
      NULL,
      0,
      0,
      0,
      0,
      1,
      0.668470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.936290,
      NULL,
      1,
      0,
      0.357188,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      9,
      2,
      0,
      NULL,
      0,
      0.525762,
      3.012900,
      3.853844,
      1.742776,
      1,
      0.799521,
      NULL,
      NULL,
      NULL,
      NULL,
      3.526126,
      0.478047,
      9.281215,
      7,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.198443,
      0,
      3.409365,
      0,
      0.969865,
      3.664727,
      1,
      NULL,
      1.433814,
      2,
      0.624120,
      1,
      1.289941,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.013714,
      1.931888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.596610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.332310,
      NULL,
      '',
      '',
      0.502444,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      5,
      3,
      3,
      2,
      NULL,
      3,
      0.881152,
      NULL);
commit;
end;
/


