set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8325901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4232',
      '34020243',
      79.178472,
      NULL,
      NULL,
      315.714912,
      6,
      2.408543,
      1,
      NULL,
      0,
      ' 2-15-1987',
      NULL,
      57.300923,
      0,
      NULL,
      0,
      0.045304,
      0.285907,
      0.916086,
      1.381905,
      0.048694,
      NULL,
      NULL,
      1.398758,
      1.968492,
      1.322676,
      0,
      1.240712,
      0.301701,
      1,
      NULL,
      8,
      1.249833,
      4.242145,
      1,
      NULL,
      1.724197,
      3.127228,
      0,
      2.283990,
      1.417755,
      3.350144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.766942,
      0.553355,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.602350,
      1.193207,
      2.756521,
      0,
      3,
      2.418207,
      0,
      NULL,
      NULL,
      4.616519,
      1.639169,
      1.468235,
      NULL,
      NULL,
      0.918861,
      0,
      0,
      1,
      1.853764,
      NULL,
      0,
      0.712235,
      0,
      0.010024,
      0.756526,
      5.976598,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.724021,
      0.336566,
      5,
      0,
      1,
      6,
      9.455700,
      2.558234,
      5,
      0,
      4,
      6.227948,
      NULL,
      5.062468,
      3.070929,
      NULL,
      3,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.924821,
      0,
      1,
      0,
      NULL,
      0,
      0.712488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.236194,
      NULL,
      6.215916,
      3.837880,
      1.959205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.039664,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065268,
      3,
      6.322337,
      3.815929,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.868462,
      0.427467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.362430,
      NULL,
      0.915047,
      0.282554,
      NULL,
      1,
      2,
      0,
      NULL,
      1,
      0.392057,
      NULL,
      0.837754,
      1.404665,
      0.636149,
      1.597115,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '13014',
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      4.293989,
      0.145456,
      NULL,
      1.752216,
      1.360962,
      0.425363,
      4.572343,
      2.201237,
      2.262138);
commit;
end;
/


