set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8325901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0444',
      '40323312',
      NULL,
      13,
      '4443341',
      326.087591,
      NULL,
      2.722651,
      2,
      '443431',
      NULL,
      ' 7- 3-2003',
      NULL,
      6.293619,
      0,
      NULL,
      0,
      1.242460,
      0.235637,
      1,
      1.152837,
      0,
      1,
      1.298362,
      2,
      NULL,
      6.990433,
      0.184294,
      0.392510,
      0.441461,
      0.199833,
      3,
      2,
      1,
      0.994277,
      NULL,
      0.582826,
      1,
      6.556298,
      NULL,
      3.051030,
      NULL,
      1.788527,
      0,
      NULL,
      NULL,
      0.443192,
      NULL,
      NULL,
      1.978359,
      1.613921,
      0.045753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.695024,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.895603,
      0.633174,
      NULL,
      NULL,
      0,
      5.873565,
      6.894258,
      NULL,
      NULL,
      1,
      1.292598,
      NULL,
      1,
      3.192736,
      1.750309,
      1,
      NULL,
      1.832127,
      0,
      NULL,
      1.953995,
      0,
      1.967271,
      1.720085,
      NULL,
      2.722267,
      1.649983,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      4.224844,
      0,
      NULL,
      0.852163,
      0.767102,
      1.339225,
      3.343154,
      7.680764,
      NULL,
      2.735518,
      1.228512,
      1.919098,
      5.005267,
      5,
      3,
      NULL,
      3,
      0.875176,
      1.736750,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.649590,
      1,
      1,
      1,
      0,
      1.483274,
      0.007753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.813528,
      NULL,
      5.240191,
      2,
      3.568377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.340457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      7.980781,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.194117,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.071517,
      1,
      2,
      1.943242,
      NULL,
      0.015070,
      0.564145,
      0,
      NULL,
      0.782500,
      NULL,
      0.500535,
      0.133697,
      1.782693,
      0.693813,
      0.131242,
      1.216064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      '',
      0.891466,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      1.432560,
      1.232958,
      2.792173,
      3.835288,
      3.546242,
      1,
      2,
      3,
      2);
commit;
end;
/


