set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9435005';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-6-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '40',
      34.354170,
      NULL,
      '2224203',
      48.280759,
      6,
      NULL,
      2,
      '241134',
      3.569450,
      ' 9- 2-1976',
      45,
      45,
      0.414883,
      NULL,
      1.493030,
      NULL,
      1,
      1,
      NULL,
      1.054574,
      1.533350,
      0.158227,
      2,
      0.751640,
      0.671472,
      1,
      1.600115,
      1.393131,
      0,
      1.546315,
      1.900541,
      NULL,
      1,
      NULL,
      1.391102,
      NULL,
      3,
      0,
      0.403668,
      0,
      1.245185,
      1.781836,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.424485,
      0.111943,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.330109,
      0.383605,
      NULL,
      0.733884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.793464,
      0.037201,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      1.849422,
      0.186272,
      1,
      1.815586,
      0.796171,
      NULL,
      NULL,
      NULL,
      0,
      0.240938,
      0,
      NULL,
      0.563126,
      1.497929,
      4.605759,
      NULL,
      3,
      1.371868,
      0,
      NULL,
      0.337874,
      1.466113,
      1,
      3,
      1,
      4,
      3.083965,
      7.916828,
      6.828290,
      7.890054,
      2.607782,
      NULL,
      1,
      0.332421,
      0,
      NULL,
      NULL,
      0.200706,
      1.989927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.288049,
      1,
      1,
      NULL,
      0.671217,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      0.321795,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.231317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.198672,
      NULL,
      NULL,
      0,
      1.114219,
      NULL,
      NULL,
      NULL,
      1,
      0.052591,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.851564,
      0,
      0.166726,
      1.566234,
      1,
      3.480784,
      1.917779,
      0.990236,
      3,
      NULL,
      0.644898,
      0,
      1,
      0,
      1,
      0.652697,
      1.055592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.833358,
      '3222',
      '',
      NULL,
      1.487421,
      NULL,
      '',
      NULL,
      0.374145,
      '',
      NULL,
      '',
      0,
      NULL,
      NULL,
      1,
      3.249184,
      3.451260,
      3.680494,
      2,
      NULL);
commit;
end;
/


