set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9435005';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '133',
      '10140041',
      45,
      3.111161,
      '3121001',
      53,
      1,
      NULL,
      3,
      '411303',
      NULL,
      ' 8-11-1980',
      41.156341,
      2.703905,
      1.695701,
      NULL,
      1,
      1.499421,
      2,
      0.331364,
      NULL,
      0.853010,
      0,
      0.847673,
      3.187682,
      1,
      1,
      0,
      0,
      0.853244,
      0,
      1,
      0.355560,
      0,
      NULL,
      0.471066,
      1,
      1,
      1.593645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.805523,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.757967,
      0.426217,
      0,
      0.606989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.695833,
      1,
      1,
      0.019156,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1.558882,
      NULL,
      1,
      NULL,
      1.601598,
      1,
      0,
      1,
      NULL,
      1,
      0.352740,
      1,
      0.763454,
      3,
      1.647255,
      NULL,
      0.226504,
      3.672344,
      NULL,
      4.340964,
      0,
      0,
      NULL,
      3,
      0,
      NULL,
      6.928484,
      0.534746,
      4,
      3,
      7,
      NULL,
      NULL,
      2.542345,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3.611380,
      0.493209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.079009,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.006671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.074202,
      NULL,
      6,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.593836,
      3.180695,
      0.031096,
      NULL,
      NULL,
      NULL,
      2.284298,
      2.210269,
      0.573267,
      3.241558,
      NULL,
      0,
      0.453985,
      NULL,
      NULL,
      NULL,
      1.433801,
      6,
      0.786405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.956044,
      0,
      1.460944,
      0.952118,
      NULL,
      3,
      0,
      NULL,
      0,
      3,
      2.032429,
      0.324599,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.316672,
      0.273664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.665663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.559936,
      '2443',
      '1420',
      '',
      1,
      NULL,
      '',
      '',
      1.563632,
      '',
      '',
      '',
      5,
      4,
      0,
      NULL,
      1,
      2.128327,
      0.959633,
      1.920426,
      2.751004);
commit;
end;
/


