set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9435005';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-1-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2032',
      '03430244',
      42.297733,
      29,
      NULL,
      88,
      4,
      NULL,
      NULL,
      '431022',
      4.076416,
      NULL,
      NULL,
      NULL,
      0.668113,
      NULL,
      NULL,
      2.343034,
      0,
      1.727847,
      0.763786,
      0.306723,
      0.344403,
      0.136022,
      NULL,
      1,
      1,
      NULL,
      0,
      1.764266,
      0,
      0.216841,
      0.653667,
      0.619158,
      0.415374,
      0.348998,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.313452,
      1.977035,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.499702,
      NULL,
      1.175765,
      1.705928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.544627,
      0,
      1.108930,
      0,
      1.224803,
      1,
      1,
      1.153534,
      1,
      NULL,
      1,
      0.052652,
      1,
      1.536354,
      1,
      1.678003,
      1,
      0,
      0,
      NULL,
      1.096165,
      4.885448,
      0.288421,
      1,
      3,
      1,
      4.125753,
      0.528751,
      6,
      7,
      0.016838,
      2.620102,
      4,
      3,
      NULL,
      0.339252,
      3.639117,
      0,
      NULL,
      2,
      4,
      0,
      1,
      7.218069,
      4,
      1.134712,
      0,
      0.866183,
      1,
      NULL,
      NULL,
      1,
      1.345674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.198129,
      1.725864,
      NULL,
      1,
      1,
      1.965349,
      1.548441,
      0.923095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.367574,
      NULL,
      0.010092,
      3.142182,
      0.693133,
      0.134914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.739082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      5.062293,
      4.158769,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3.017754,
      0,
      0.304981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.879954,
      3,
      3,
      0.778012,
      NULL,
      1,
      1,
      1,
      0.062755,
      0,
      0.094359,
      0,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.195443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '1011',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      0.879023,
      '',
      '',
      '',
      2,
      1,
      3.533538,
      2,
      3.341178,
      2,
      0,
      NULL,
      1.912149);
commit;
end;
/


