set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8937818';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-12-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0403',
      '04300040',
      28.132451,
      53,
      '0430142',
      2.530881,
      2,
      1,
      3,
      '121023',
      5,
      NULL,
      50.800334,
      16,
      1.683967,
      NULL,
      1,
      1,
      3,
      1,
      NULL,
      0,
      1,
      2.580499,
      0,
      0.259687,
      1,
      0,
      0,
      0,
      0.887253,
      NULL,
      0.140979,
      0,
      0,
      0,
      NULL,
      NULL,
      7,
      NULL,
      3,
      2,
      1.371759,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.225426,
      0,
      1.398229,
      1,
      1,
      NULL,
      1,
      1.005941,
      3.340303,
      1,
      1,
      0.023352,
      NULL,
      2,
      1.822868,
      NULL,
      0,
      1,
      1,
      0.076157,
      0.758658,
      0,
      3.059347,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.889448,
      NULL,
      NULL,
      0,
      0.641357,
      2,
      0,
      1,
      0.762821,
      NULL,
      0.687977,
      1.043785,
      0,
      0.449711,
      0.171116,
      0,
      1,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      1.750393,
      1,
      0.757381,
      5.045631,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.091502,
      1.776723,
      4,
      NULL,
      1.403141,
      1.825050,
      0,
      NULL,
      3,
      0,
      0.417452,
      NULL,
      3,
      NULL,
      1.251395,
      NULL,
      2.701638,
      1,
      1,
      0,
      1,
      1,
      0,
      0.851095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.257446,
      1.413695,
      2,
      0,
      0,
      4,
      1.142583,
      0.317929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.114991,
      0.574076,
      2,
      0,
      2,
      0.769046,
      1,
      2.417588,
      0.084221,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.112304,
      NULL,
      0.695839,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0.958128,
      1,
      0.529471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2.491533,
      0.943822,
      0,
      2,
      0,
      NULL,
      1.797480,
      1.121307,
      3,
      NULL,
      NULL,
      1.013420,
      1,
      0,
      0.677506,
      1,
      0.280939,
      0.215551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.959979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '10332',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0.974366,
      '00140',
      '',
      NULL,
      2,
      1.347037,
      NULL,
      2.212287,
      2,
      2,
      0.222082,
      3.219995,
      6);
commit;
end;
/


