set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9532151';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '141',
      NULL,
      37,
      NULL,
      '4314424',
      58.069089,
      4,
      1.411014,
      NULL,
      '124302',
      4,
      ' 4-21-1977',
      25,
      NULL,
      0.761800,
      NULL,
      NULL,
      NULL,
      1,
      0.449974,
      0,
      1,
      1,
      3,
      NULL,
      0,
      1.828260,
      0,
      1.716517,
      0,
      1.785891,
      1,
      0,
      1.902569,
      NULL,
      NULL,
      0.345812,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.707721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.979596,
      1.835603,
      0.859406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.268792,
      0.444532,
      1.074463,
      1.722526,
      0,
      0.961100,
      0,
      0,
      1,
      NULL,
      0,
      1.895326,
      NULL,
      1.689776,
      1.551442,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.347689,
      0.135768,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.861962,
      NULL,
      1.749257,
      0,
      8,
      4,
      4,
      7,
      9.091636,
      6,
      7.847997,
      0.397512,
      1,
      0.304821,
      1.827585,
      1.565166,
      NULL,
      NULL,
      0,
      0.973856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.432925,
      0.774532,
      0,
      NULL,
      0,
      0.003594,
      1.255005,
      0.577418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.691523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.277692,
      0,
      NULL,
      0.824070,
      0,
      NULL,
      NULL,
      0.846972,
      1.034377,
      1,
      NULL,
      1,
      0.150139,
      NULL,
      NULL,
      NULL,
      NULL,
      3.167007,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.932671,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      2.371226,
      1.436935,
      0.182299,
      0.061827,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.147304,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.736550,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      3,
      1,
      2.835379,
      0.168111,
      0.320493,
      5,
      0,
      NULL);
commit;
end;
/


