set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9705629';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-7-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '220',
      '33',
      37,
      NULL,
      '4334232',
      14,
      2,
      1.254004,
      NULL,
      '131343',
      5.869811,
      ' 6-23-1995',
      42.725441,
      77.052133,
      0.753717,
      NULL,
      1.995088,
      0.027310,
      NULL,
      NULL,
      0.239043,
      3.592805,
      NULL,
      0.900850,
      NULL,
      1.945006,
      3.655326,
      0,
      0.814682,
      0,
      0,
      1.930062,
      1,
      0,
      1.694923,
      1.316523,
      0.459349,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.807172,
      1,
      1.906660,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.233226,
      0,
      NULL,
      1.763604,
      NULL,
      0,
      0.992363,
      0.355813,
      0,
      0,
      1.401260,
      0,
      0,
      0.090781,
      0.448567,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      0.739220,
      NULL,
      NULL,
      1,
      0.217669,
      NULL,
      NULL,
      NULL,
      NULL,
      5.006827,
      4.016479,
      3.134841,
      NULL,
      0.154587,
      1.311262,
      1.936957,
      NULL,
      1,
      1,
      1.016302,
      NULL,
      0,
      NULL,
      1.486392,
      0.693122,
      NULL,
      NULL,
      NULL,
      7,
      0.943936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.164889,
      0.572168,
      0,
      1,
      NULL,
      0.983699,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.103976,
      NULL,
      NULL,
      NULL,
      0.576264,
      1,
      0,
      1,
      1,
      1,
      0.265364,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.347302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.214821,
      0,
      1.888832,
      2,
      NULL,
      NULL,
      1.664314,
      0,
      0,
      1,
      0,
      1.791742,
      NULL,
      NULL,
      NULL,
      1.134613,
      0,
      0.670643,
      1,
      0.080386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.679298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.524140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.578225,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.006590,
      NULL,
      NULL,
      1.095116,
      0.104903,
      0,
      1,
      1,
      '23442',
      '',
      '',
      0.419947,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      1.450487,
      2,
      2,
      NULL,
      3,
      0,
      1.196953,
      0.043092,
      NULL);
commit;
end;
/


